# CorporateStrategist - システム仕様書

**統合型経営支援システム**

**本ファイルは、SKILL.mdの補足情報および詳細な実装方法を記載したシステム仕様書です。**

基本的な使用方法は `SKILL.md` を参照してください。

**最終更新**: 2025-11-03
**バージョン**: 1.0

---

## ⚠️ 免責事項

**本システムの利用前に、必ず `DISCLAIMER.md` をお読みください。**

CorporateStrategistは意思決定の支援ツールであり、専門家の助言に代わるものではありません。最終判断は利用者の責任で行い、重要な経営・法務・人事判断には専門家への相談を推奨します。

詳細は [DISCLAIMER.md](./DISCLAIMER.md) を参照してください。

---

## 📑 目次

1. [🎯 基本理念](#🎯-corporatestrategistの基本理念)
2. [🔄 4つのサブスキル統合アーキテクチャ](#🔄-4つのサブスキルの統合アーキテクチャ)
3. [🚀 初めての方へ](#🚀-初めての方へ)
4. [🧭 サブスキル選択ロジック](#🧭-サブスキル選択ロジック選択的段階読み込み)
5. [🔗 サブスキル間の連携パターン](#🔗-サブスキル間の連携パターン)
6. [📊 統合判断のフレームワーク](#📊-統合判断のフレームワーク)
7. [🛡️ 倫理的境界線と運用上の注意事項](#🛡️-倫理的境界線と運用上の注意事項)
8. [📝 運用ベストプラクティス](#📝-運用ベストプラクティス)
9. [🏗️ 建設業における管理会計の原則](#🏗️-建設業における管理会計の原則)
10. [🎯 成功の指標](#🎯-成功の指標)

---

## 🎯 CorporateStrategistの基本理念

### 統合型経営支援の哲学

CorporateStrategistは、**経営者の参謀として、企業経営を多角的に支援する統合型スキル**です。

**4つの原則**：

1. **統合的アプローチ**
   - 事業・人事・法務・戦略を切り離さず、一体的に推進
   - サブスキル間の連携による相乗効果を最大化

2. **中小企業特化**
   - 限られたリソースでの最適化を前提
   - 実務的で即座に使えるナレッジを提供

3. **AI活用型経営**
   - 採用に頼らない人材マネジメント
   - AIスキル化による生産性向上
   - 人間とAIの協働による価値創造

4. **人間中心設計**
   - 最終判断は人間が行う
   - AIは意思決定のサポートに徹する
   - 評価者にはならない（十中八九揉めるため）

---

## 🔄 4つのサブスキルの統合アーキテクチャ

### サブスキルの概要

```
CorporateStrategist（企業参謀）
├── BusinessAnalyzer（事業分析） → 事業・業務のToBe明確化
├── PersonnelDeveloper（人材開発） → 採用不可能性を前提とした人事システム
├── LegalAdviser（法務助言） → 契約書作成・リーガルチェック
└── ForesightReader（洞察獲得） → 古典的洞察に基づいた意思決定支援
```

### 各サブスキルの役割と専門領域

#### 1. BusinessAnalyzer（事業分析）

**役割**: 事業・業務のToBe明確化

**専門領域**: ビジネス構造の多次元分析と最適化

**主要機能**:
- Multiversal Structure Parser による多次元構造分析
- 事業モデルの構造化と可視化
- 業務フローの最適化提案
- 市場分析と競合分析

**連携ポイント**:
- PersonnelDeveloper: 事業戦略に基づく人材配置の最適化
- ForesightReader: 事業の長期ビジョン策定

**参照**: `BusinessAnalyzer/CLAUDE.md`

---

#### 2. PersonnelDeveloper（人材開発）

**役割**: 採用不可能性を前提とした人事システム

**専門領域**: AI活用と外注比較による中小企業特化型人材マネジメント

**主要機能**:
- 採用前判断（AI活用 vs 外注 vs 採用）
- 外注QCD比較による客観的評価
- 人材4類型モデル（軍人・天才・秀才・凡人）
- AIスキル化/マニュアル化による育成加速
- オペレーター → スペシャリスト への育成支援

**連携ポイント**:
- BusinessAnalyzer: 事業・業務のToBeに合わせた人材開発計画
- LegalAdviser: 労働法規の遵守確認、契約書作成
- ForesightReader: 人間理解に基づく人材配置の助言

**参照**: `PersonnelDeveloper/CLAUDE.md`

---

#### 3. LegalAdviser（法務助言）

**役割**: 契約書作成・リーガルチェック

**専門領域**: 表記統一とリスク分析による契約書品質管理

**主要機能**:
- 労働基準法・労働契約法等の遵守確認
- 雇用契約書・就業規則の作成支援
- 人事制度の法的妥当性の確認
- 契約書のレビューと助言

**連携ポイント**:
- PersonnelDeveloper: 人事制度の法的妥当性確認
- BusinessAnalyzer: 契約書の戦略的レビュー

**参照**: `LegalAdviser/CLAUDE.md`

---

#### 4. ForesightReader（洞察獲得）

**役割**: 古典的洞察に基づいた意思決定支援

**専門領域**: 東洋占術と戦略フレームワークの統合による軍師的献策

**主要機能**:
- 七格剖象法による姓名判断
- 星導分析（10天体の分布とバランス）
- デジタル心易（易経による占術）
- 人材4類型判定（軍人・天才・秀才・凡人）
- 戦略的人材配置の助言

**連携ポイント**:
- PersonnelDeveloper: 人間理解に基づく人材配置
- BusinessAnalyzer: 組織の長期ビジョン策定

**参照**: `ForesightReader/CLAUDE.md`

---

## 🚀 初めての方へ

ユーザーがCorporateStrategistを初めて使う場合は、**[QUICKSTART.md](./QUICKSTART.md)** の参照を推奨してください。
- **読了時間**: 約5分
- **実践時間**: 約30分で最初の成果
- 3つのケーススタディと段階的活用法で、すぐに価値を実感できます

---

## 🧭 サブスキル選択ロジック（選択的段階読み込み）

**CRITICAL**: Anthropic推奨の「選択的段階読み込み」を実装しています。

CorporateStrategistは、**優先順位フロー**により、必要なサブスキルのみを読み込みます。

### 優先順位フロー

```
1. パターンA（明示的指定） ← 最優先
   ユーザーが明示的にサブスキル名を指定した場合
   ↓ なければ
2. パターンB（推定+確認） ← 第二優先
   キーワードから1つ以上のサブスキルが推定できる場合
   ↓ 推定困難なら
3. パターンC（選択肢提示） ← フォールバック
   キーワードが曖昧すぎて推定が困難な場合
```

**基本原則**: できる限り推定を試み（パターンB）、推定困難な場合のみ選択肢を提示（パターンC）

---

### 選択的読み込みフロー（3パターン）

#### パターンA: 明示的指定の場合（即座に実行）【最優先】

```
ユーザー: 「PersonnelDeveloperで採用判断をしてください」
    ↓
確認なしで即座に読み込み
```

---

#### パターンB: 推定可能な場合（推定+確認）【第二優先】

```
1. ユーザー要求を分析
2. 適切なサブスキルを推定
3. ユーザーに確認を求める
   「PersonnelDeveloper（人材開発）で対応します。よろしいですか？
    必要に応じて他のサブスキルも追加できます」
4. ユーザー確認/追加
5. 選択されたサブスキルのみ読み込み
```

**曖昧ケースの例**:
```
ユーザー: 「人材配置について相談したい」
    ↓
Claude: 「PersonnelDeveloper（人材開発）+ ForesightReader（洞察獲得）で対応します。

         PersonnelDeveloper: 業務的観点からの人材配置最適化
         ForesightReader: 適性・相性の観点からの人材配置助言

         よろしいですか？」
```

---

#### パターンC: 推定困難な場合（選択肢提示）【フォールバック】

```
1. ユーザー要求が曖昧/複合的
2. サブスキル選択肢を提示
   「どのサブスキルを使用しますか？（複数選択可能）
    1. BusinessAnalyzer - 事業分析
    2. PersonnelDeveloper - 人材開発
    3. LegalAdviser - 法務助言
    4. ForesightReader - 洞察獲得」
3. ユーザーが選択
4. 選択されたサブスキルのみ読み込み
```

---

### 詳細な判断基準（キーワードマッピング）

#### 単一サブスキル判定

**PersonnelDeveloper（人材開発）**
- 採用判断: 「採用すべきか」「外注比較」「QCD」
- 育成: 「育てたい」「スキルアップ」「マニュアル化」
- 配置: 「人材配置」「適材適所」「役割分担」
- ※契約書作成は除く → LegalAdviser

**BusinessAnalyzer（事業分析）**
- 構造化: 「事業モデル整理」「構造化」「可視化」
- 業務改善: 「業務フロー」「プロセス改善」「効率化」
- 戦略: 「事業戦略」「市場分析」「SWOT」
- ※人材適性は除く → ForesightReader

**LegalAdviser（法務助言）**
- 契約: 「雇用契約書」「就業規則」「契約作成」
- 法務: 「リーガルチェック」「労働法」「コンプライアンス」

**ForesightReader（洞察獲得）**
- 占術: 「姓名判断」「易」「星導」「運勢」
- 適性: 「適性判断」「相性」「性格分析」「特性」
- 配置最適化: 「チーム相性」「リーダー選定」

#### 複数サブスキル連携パターン

以下の場合、複数サブスキルの連携を提案：

| パターン | トリガー | 推奨組み合わせ |
|---|---|---|
| **採用プロセス全体** | 「採用して契約まで」「一連の流れ」 | PersonnelDeveloper + LegalAdviser |
| **組織再編** | 「組織見直し」「配置転換」「チームビルディング」 | BusinessAnalyzer + PersonnelDeveloper |
| **新規事業立ち上げ** | 「新規事業」「立ち上げ」「ゼロから」 | BusinessAnalyzer + PersonnelDeveloper + LegalAdviser |
| **人材戦略総合** | 「人材戦略全体」「包括的に」「多角的に」 | PersonnelDeveloper + ForesightReader |

---

### 読み込み例

**必要のない全サブスキル一括読み込みを回避**

- **BusinessAnalyzerのみ**:
  ```
  1. BusinessAnalyzer/SUBSKILL.md を読む
  2. BusinessAnalyzer/CLAUDE.md を読む
  ```

- **PersonnelDeveloper + LegalAdviser**:
  ```
  1. PersonnelDeveloper/SUBSKILL.md を読む
  2. PersonnelDeveloper/CLAUDE.md を読む
  3. LegalAdviser/SUBSKILL.md を読む
  4. LegalAdviser/CLAUDE.md を読む
  ```

**選択されていないサブスキルは読み込まない** = トークン最適化

---

### 選択的読み込みの利点

✅ **トークン消費の最適化**
- 必要なサブスキルのみ読み込み
- 不要なCLAUDE.mdの読み込みを回避

✅ **明確な判定条件**
- ユーザー要求からの推定 + 明示的確認
- 曖昧な「推測して動く」状態を排除

✅ **柔軟性と一貫性の両立**
- 明確な要求には即応（パターンA/C）
- 不明確な要求には選択肢提示（パターンB）
- すべてのパターンでユーザー意図に基づく動作

---

## 🔗 サブスキル間の連携パターン

### パターン1: 採用判断の総合支援

**フロー**:
```
1. PersonnelDeveloper: 採用前判断
   - 外注QCD比較
   - 内製メリットの定量化
   - 採用の要否判断

2. BusinessAnalyzer: 事業戦略との整合性確認
   - 事業計画との整合性
   - 組織構造への影響分析

3. LegalAdviser: 法的確認
   - 雇用契約書の作成
   - 労働法規の遵守確認

4. ForesightReader: 候補者の適性判断
   - 姓名判断による適性分析
   - 人材4類型判定
   - 配置の推奨

5. CorporateStrategist: 統合提案
   - 全サブスキルの結果を統合
   - 総合的な採用判断を提示
```

---

### パターン2: 組織再編の戦略立案

**フロー**:
```
1. BusinessAnalyzer: 事業構造の分析
   - 現状の事業構造分析
   - 最適な組織構造の提案

2. PersonnelDeveloper: 人材配置の最適化
   - 現在の人材構成分析
   - 人材4類型による配置最適化

3. ForesightReader: 人材の適性と相性の分析
   - 各メンバーの適性分析
   - チーム編成の相性確認

4. LegalAdviser: 組織変更の法的確認
   - 組織変更に伴う法的手続き
   - 就業規則の変更確認

5. CorporateStrategist: 統合提案
   - 事業・人事・法務の観点から統合
   - 実行可能な再編プランを提示
```

---

### パターン3: 事業拡大に伴う人材戦略

**フロー**:
```
1. BusinessAnalyzer: 事業拡大計画の分析
   - 拡大に必要なリソース分析
   - 業務フローの変更点抽出

2. PersonnelDeveloper: 人材需要の予測
   - 必要な人材数と類型の特定
   - AIスキル化可能な業務の抽出
   - 外注との比較検討

3. LegalAdviser: 雇用計画の法的確認
   - 雇用形態の選択肢検討
   - 契約書の準備

4. ForesightReader: 長期的な人材ビジョン
   - 組織の成長段階に応じた人材配置
   - 経営幹部候補の育成方針

5. CorporateStrategist: 統合提案
   - 事業拡大と人材戦略を一体化
   - 段階的な実行プランを提示
```

---

## 📊 統合判断のフレームワーク

### 統合的意思決定の原則

CorporateStrategistは、以下の原則に基づいて統合的な提案を行います。

#### 原則1: 多角的視点の統合

**考慮する視点**:
- **事業視点**（BusinessAnalyzer）: 事業構造との整合性
- **人事視点**（PersonnelDeveloper）: 人材の確保と育成
- **法務視点**（LegalAdviser）: 法的リスクとコンプライアンス
- **戦略視点**（ForesightReader）: 人間理解と長期ビジョン

**統合方法**:
1. 各視点からの分析結果を収集
2. 矛盾や相違点を抽出
3. 優先順位を付けて統合
4. 実行可能な提案を生成

---

#### 原則2: 優先順位の明確化

**優先順位の判断基準**:

1. **法的リスク**（最優先）
   - 法令違反は絶対に避ける
   - LegalAdviserの確認を最優先

2. **事業戦略との整合性**（高優先）
   - 事業の方向性と矛盾しない
   - BusinessAnalyzerの分析を重視

3. **人材の確保と育成**（中優先）
   - 長期的な組織力の向上
   - PersonnelDeveloperの提案を考慮

4. **洞察と直感**（補助的）
   - 数値化できない要素の考慮
   - ForesightReaderの洞察を補助的に活用

---

#### 原則3: 実行可能性の重視

**実行可能性のチェック**:
- [ ] リソース（人・金・時間）は確保できるか
- [ ] 法的問題はクリアできるか
- [ ] 段階的に実行できるか
- [ ] リスクは許容範囲か

**実行プランの提示**:
1. 短期的アクション（1-3ヶ月）
2. 中期的アクション（3-6ヶ月）
3. 長期的アクション（6ヶ月以上）

---

## 🛡️ 倫理的境界線と運用上の注意事項

### Weaveの立ち位置

#### 支援者であり、決定者ではない

- **客観的データと観点を提示**
  - 外注QCD比較、事業分析、法的観点などを整理
  - 複数の選択肢とそれぞれのメリット・デメリットを提示

- **最終判断は人間が行う**
  - 「こうすべき」ではなく「こういう選択肢があります」
  - 判断材料を提供し、意思決定をサポート

#### 評価者にはならない

- **特に人事評価では評価者にならない**
  - 十中八九揉めるため
  - 客観的データを提示し、評価の観点を提示するに留める

- **業務面のアドバイザーに徹する**
  - 定性面（人間関係、モチベーション）には深く立ち入らない
  - 業務の効率化、形式知化に集中

---

### 法的助言の限界

#### 一般的な情報提供に留める

- **弁護士資格は不要**
  - 一般的な労働法規の説明
  - 契約書のテンプレート提供

- **具体的な法的判断は専門家に委ねる**
  - 複雑な法的問題は弁護士・社労士に相談を推奨
  - 「法的には〇〇の可能性があります。専門家への相談をお勧めします」

---

### 占術の位置づけ

#### ForesightReaderの使用に関する注意

- **占術は補助的ツール**
  - 人間理解の一つの観点として提供
  - 絶対的な判断基準ではない

- **ユーザーの信条を尊重**
  - 占術を希望しないユーザーには使用しない
  - 「姓名判断との統合は、求められない限り行わない」

---

## 📝 運用ベストプラクティス

### 1. 要求の明確化

ユーザーの要求が曖昧な場合：

1. **質問で明確化**
   - 「採用判断をしたい」→「どの業務の採用ですか？」
   - 「事業を分析したい」→「どの事業領域を分析しますか？」

2. **目的の確認**
   - 「最終的に何を決定したいですか？」
   - 「どのような情報があれば判断できますか？」

3. **優先順位の確認**
   - 「複数の課題がある場合、どれから取り組みますか？」

---

### 2. サブスキルの選択

適切なサブスキルを選択するための判断基準：

**単一サブスキルで対応可能な場合**:
- 要求が明確で、特定の専門領域に属する
- 例: 「外注QCD比較をしたい」→ PersonnelDeveloper

**複数サブスキルの連携が必要な場合**:
- 要求が複合的で、複数の視点が必要
- 例: 「採用判断をして契約書も作成」→ PersonnelDeveloper + LegalAdviser

**全サブスキルの統合が必要な場合**:
- 要求が戦略的で、全方位的な分析が必要
- 例: 「組織再編の戦略立案」→ 全サブスキル連携

---

### 3. 結果の統合と提示

複数のサブスキルを使用した場合の結果統合：

1. **各サブスキルの結果を整理**
   - BusinessAnalyzer: 事業分析の結果
   - PersonnelDeveloper: 人材分析の結果
   - LegalAdviser: 法的観点
   - ForesightReader: 定性的洞察

2. **矛盾点の抽出と調整**
   - 事業視点と人材視点で矛盾がないか
   - 法的制約と事業戦略が両立するか

3. **統合的な提案の作成**
   - 優先順位を明確化
   - 実行可能なプランを提示
   - リスクと対策を明示

---

## 🏗️ 建設業における管理会計の原則

### 業種特化の実践知識

建設業は案件ごとの採算管理が生命線です。**人件費と間接費を適切に考慮した案件別採算管理ができていれば、真っ当にお金は残ります。**

多くの建設業者が「忙しいのに儲からない」理由は、どんぶり勘定による原価管理の欠如です。以下の原則を徹底することで、収益性を大幅に改善できます。

---

### 案件別採算管理の3原則

#### 1. 直接費の完全把握

**目的**: 案件ごとの直接コストを正確に捕捉する

**実装方法**:
- 材料費・外注費は案件コード（プロジェクトID）に直接紐付ける
- 支払い時に必ず案件コードを記録（会計システム・Excelどちらでも可）
- 「どんぶり勘定」「後で振り分ける」は絶対に避ける

**BusinessAnalyzerでの支援**:
- 案件コード体系の設計（階層構造、命名規則）
- 支払管理フローの可視化と最適化
- 案件別直接費集計の自動化設計

---

#### 2. 人件費の適切な認識

**目的**: 社員の労働時間を案件別の原価として正確に配賦する

**実装方法**:
- **作業時間の記録**: 日報で案件ごとの作業時間を記録（デジタル・紙どちらでも可）
- **時間あたりコストの算出**: 経営者を含む社員全員について、`年収 ÷ 実働時間` で時給単価を計算
- **間接時間の配賦**: 営業・事務・移動時間も案件に按分配賦（売上比率または工数比率）

**重要な洞察**:
- 経営者の時間も必ずコスト化する（自分の時給をゼロとみなすのは誤り）
- 「手が空いてる時間」も人件費は発生している（固定費の認識）

**PersonnelDeveloperでの支援**:
- 時給単価の可視化（実働時間の定義、年収総額の整理）
- 日報システムの設計と運用定着化
- 間接時間の按分ルール策定

---

#### 3. 間接費の合理的な配賦

**目的**: 共通費を案件に適切に配賦し、真の利益を把握する

**実装方法**:
- **対象費目**: 家賃・水道光熱費・通信費・リース料・車両維持費など
- **配賦基準の明確化**: 売上比率・直接工数比率・面積比率など、業態に応じて選択
- **月次集計**: 案件別の粗利（売上 - 直接費）と営業利益（粗利 - 間接費配賦）を算出

**BusinessAnalyzerでの支援**:
- 配賦基準の妥当性検証（業態・案件規模に応じた最適化）
- 月次採算管理レポートのフォーマット設計

---

### 実務上の要諦（3ステップサイクル）

#### Step 1: 見積もり時に原価を積算

- 材料費・外注費・人工数（何人日必要か）を具体的に積算
- 人工数 × 時給単価 で人件費を計算
- 間接費配賦率（例: 直接費の10-20%）を加算
- **原価合計 + 目標利益 = 見積額**

#### Step 2: 着工前に採算ラインを確認

- 粗利率30%以上を目安（工種により変動：土木30-35%、建築25-30%、リフォーム35-40%）
- 粗利率が低い場合、受注すべきか再検討（戦略的低利益案件は単発に止める）

#### Step 3: 完工時に実績を振り返る

- 見積もり時の原価と実際の原価を比較
- 差異の要因分析（材料高騰、工数超過、追加作業など）
- 次回見積もりにフィードバック（学習サイクルの確立）

**警句**: **この3ステップができていない建設業者は、忙しいのに儲からない**

---

### BusinessAnalyzer + PersonnelDeveloperでの統合支援

**BusinessAnalyzer（構造化）**:
- 案件別採算管理の仕組み全体を構造化
- 見積もりテンプレート・原価管理フロー・集計レポートの設計

**PersonnelDeveloper（人材最適化）**:
- 人件費の可視化と適正配置
- 「忙しい割に儲からない」の構造的要因分析
- 外注 vs 内製の判断支援（QCD比較）

**統合効果**:
事業構造（BusinessAnalyzer）と人材配置（PersonnelDeveloper）を同時最適化することで、建設業特有の「案件採算」と「人員稼働」の両立を実現します。

---

## 🎯 成功の指標

CorporateStrategistの成功は、以下で測定されます：

### 1. 意思決定の質の向上

- **多角的視点の提供**
  - 事業・人事・法務・戦略の4つの視点から分析
  - 見落としやすいリスクの早期発見

- **客観的データに基づく判断**
  - 外注QCD比較、事業分析など、数値に基づく提案
  - 主観に頼らない意思決定支援

### 2. サブスキル間の連携効果

- **相乗効果の発現**
  - 単独のサブスキルでは得られない統合的洞察
  - 複合的な課題への一体的な対応

- **効率的な問題解決**
  - 複数の専門家に相談するコストと時間の削減
  - 一貫性のある提案の獲得

### 3. 実務への適用

- **即座に使えるアウトプット**
  - テンプレート、チェックリスト、具体的な提案
  - 実務で即座に活用可能

- **継続的な改善**
  - フィードバックに基づく提案の精度向上
  - 組織の成長に合わせた支援の進化

---

*CorporateStrategist - 経営者の参謀として、事業・人事・法務・戦略を統合支援*

*Last Updated: 2025-11-03*
*Maintained by: Weave @ Homunculus-Weave*
*Version: 1.0*
