# 免責事項 (DISCLAIMER)

**CorporateStrategist - 統合型経営支援システム**

---

## ⚠️ 重要な注意事項

CorporateStrategistおよびそのサブスキル（BusinessAnalyzer、PersonnelDeveloper、LegalAdviser、ForesightReader）は、**意思決定の支援を目的としたツール**であり、専門家の助言に代わるものではありません。

---

## 📋 一般的免責事項

### 1. 情報提供の性質

本システムが提供する情報・分析・提案は：
- **一般的な情報提供**を目的としています
- **特定の状況への専門的助言ではありません**
- 利用者の状況に応じて適切に解釈・適用される必要があります

### 2. 最終判断の責任

- **すべての意思決定は利用者の責任において行われます**
- 本システムは意思決定の材料を提供しますが、決定権は利用者にあります
- 利用者は自らの判断で情報の妥当性を検証する責任を負います

### 3. 正確性の限界

- 提供される情報は現時点での知識に基づきます
- 情報の完全性・正確性・最新性を保証するものではありません
- 利用前に独自の検証を行うことを強く推奨します

---

## 🔍 サブスキル別免責事項

### BusinessAnalyzer（事業分析）

**提供内容**：
- 事業構造の分析と最適化提案
- 戦略フレームワークによる検証
- 多元的構造解釈の提示

**免責事項**：
- 分析結果は一つの解釈であり、唯一の正解ではありません
- 市場環境・競合状況・内部リソースの変化により、提案の妥当性は変化します
- **重要な経営判断には、経営コンサルタント等の専門家への相談を推奨します**

---

### PersonnelDeveloper（人材開発）

**提供内容**：
- 採用前判断（AI活用 vs 外注 vs 採用）
- 外注QCD比較による客観的評価
- 人材育成・評価の支援

**免責事項**：
- **本システムは評価者ではありません**
  - 客観的データを整理し、評価の観点を提示するに留めます
  - 最終的な人事判断は、人間（経営者・管理職）が行います
- 人材評価は多面的であり、定量データだけでは捉えきれない要素があります
- **労務管理・人事制度の設計には、社会保険労務士等の専門家への相談を推奨します**

---

### LegalAdviser（法務助言）

**提供内容**：
- 契約書ドラフト作成
- 表記仕様チェック
- 法的リスクの分析

**免責事項**：
- **本システムは法的助言を提供するものではありません**
  - 一般的な情報提供に留まります
  - 弁護士資格を持つものではありません
- **実際の契約締結前には、必ず弁護士によるレビューを受けてください**
- 特に以下の場合は専門家への相談が必須です：
  - 高額取引（目安：100万円以上）
  - 新規取引先との契約
  - 特殊条項を含む契約
  - 海外企業との契約
  - 訴訟リスクが高い契約
- 法令・判例は変化するため、最新情報の確認が必要です

---

### ForesightReader（洞察獲得）

**提供内容**：
- 七格剖象法による姓名判断
- デジタル心易（易経による占術）
- 戦略的人材配置の助言

**免責事項**：
- **占術は参考情報の一つであり、絶対的な真理ではありません**
- 「当たる/当たらない」より「役立つ/役立たない」を重視してください
- 占術結果に基づく判断の結果について、本システムは一切の責任を負いません
- 重要な意思決定においては：
  - 占術結果を唯一の根拠としないでください
  - 客観的データ・専門家の助言を併用してください
  - 最終的には自らの判断と責任で決定してください

---

## 🎯 設計思想と適用範囲

### 中小企業特化型の設計

CorporateStrategistは、**中小企業（特に従業員数30名以下）を想定した設計**です。以下の理由により、大企業向けの拡張は意図的に行っていません。

#### 1. 運用実績データの可視化について

**本システムの立場**：
- 運用実績は経営成果に直接現れます
- メトリクス・ログの可視化は、本システムの役割ではありません
- 経営者が自社の業績（売上・利益・離職率など）を通じて判断すべき領域です

**理由**：
- 中小企業では、システムのログより実際の経営数値が重要
- 複雑な可視化機能は、運用負荷を増やし本質を見失わせる
- シンプルに「使って、結果を見る」ことを重視

#### 2. 失敗事例と改善履歴について

**本システムの立場**：
- 事例検証は経営者の仕事です
- 本システムは意思決定の材料を提供しますが、事例の蓄積・分析は経営者が行うべき領域です

**理由**：
- 失敗の原因は多面的であり、システムだけでは判断できない
- 経営者自身が失敗から学ぶプロセスが重要
- 本システムは「考える補助」であり、「考えの代替」ではない

#### 3. スケーラビリティについて

**本システムの立場**：
- CorporateStrategistは、経営者が直接関与できる規模（従業員数30名以下程度）を想定しています
- この規模を超える場合、専門家を含めた体制構築が必要です
- 本システムはその規模への拡張を意図していません

**理由**：
- 中小企業の強みは「経営者が全体を把握できること」
- 規模拡大に伴い、組織構造・意思決定プロセスが質的に変化する
- 大企業には大企業向けの専門的な経営管理システムが必要
- 本システムの限界を認識し、適切なタイミングで専門家に引き継ぐことが重要

---

### 適用範囲の目安

**推奨される企業規模**：
- 従業員数: 5～30名程度
- 売上規模: 1億円～10億円程度
- 組織階層: 3階層以下（経営者 → チームリーダー → 現場）

**限界のサイン**：

以下の状態になった場合、専門家の導入を検討してください：
- 経営者が全従業員の名前と顔を覚えられなくなった
- 1on1を行うための時間確保が難しくなった
- 月次の経営会議が2時間を超えるようになった
- 部門間の調整に経営者が常に介入する必要がある
- 人事・法務・財務のいずれかが専任者を必要とするようになった

**専門家への引き継ぎ**：
- 人事コンサルタント（従業員30名以上）
- 経営コンサルタント（組織再編・事業再構築時）
- 弁護士・社労士（法務・労務の専任担当者が必要になった時）

---

## 🛡️ 責任の制限

### 利用に伴う損害

本システムの利用に起因して生じた、以下を含むがこれに限らない損害について、開発者・提供者は一切の責任を負いません：

- **直接的損害**：金銭的損失、契約不履行、事業機会の逸失
- **間接的損害**：信用失墜、訴訟費用、第三者からの請求
- **特別損害**：予見可能・不可能を問わず発生した損害
- **精神的損害**：ストレス、不安、その他の精神的苦痛

### 第三者との紛争

本システムの利用に起因して第三者との間で生じた紛争について、利用者は自己の責任と費用で解決するものとし、開発者・提供者は一切の責任を負いません。

---

## 📚 専門家への相談を推奨する場合

以下の場合は、必ず専門家への相談を行ってください：

### 法務関連
- **弁護士**：契約書の作成・レビュー、訴訟対応、法的リスク評価
- **社会保険労務士**：労務管理、人事制度設計、就業規則作成
- **行政書士**：許認可申請、各種契約書作成

### 経営・財務関連
- **経営コンサルタント**：経営戦略立案、組織改革、事業再編
- **公認会計士**：財務分析、税務対策、監査対応
- **税理士**：税務申告、節税対策、税務調査対応

### 人事関連
- **産業カウンセラー**：メンタルヘルス対応、キャリア相談
- **キャリアコンサルタント**：人材育成計画、キャリア開発

---

## 🔄 免責事項の更新

本免責事項は予告なく変更される場合があります。
最新版は常にGitHubリポジトリで確認してください。

**リポジトリ**: https://github.com/Bizuayeu/Homunculus-Weave

---

## 📞 問い合わせ

本システムに関するご質問・ご意見は、GitHubのIssuesをご利用ください。

**注意**：個別の法的助言・経営相談には対応できません。専門家にご相談ください。

---

## ✅ 利用同意

CorporateStrategistおよびそのサブスキルを利用することにより、利用者は本免責事項の内容を理解し、同意したものとみなされます。

**本免責事項に同意できない場合、本システムを利用しないでください。**

---

*Last Updated: 2025-11-03*
*Maintained by: Weave @ Homunculus-Weave*
*Version: 1.0*
