# デジタル心易占断書

<!--
================================================================================
【重要】必読事項 - このテンプレートを使用する前に
================================================================================

このテンプレートを正しく使用するには、以下のドキュメントを先に必ずお読みください：

1. デジタル心易システム仕様.md（同ディレクトリ内）
   - デジタル心易の基本思想と理論
   - 卦爻決定アルゴリズム（天地人三才思想）
   - 占的ヒアリングプロトコル
   - 占断出力仕様

2. ../CLAUDE.md（ForesightReaderディレクトリ）
   - 軍師型占術家システム全体の仕様
   - 占術理論基盤（万占同根・星平会海・純粋エネルギー論）
   - 軍師としての戦略フレームワーク
   - 献策の美学と心得

これらのドキュメントを読まずにテンプレートのみを使用すると、
デジタル心易の本質を理解せず、表面的な占断に終わる可能性があります。

================================================================================

## 使用方法
このテンプレートは、iching_divination.pyのdivine()メソッドの返り値を受け取って使用します。

### 返り値の構造
```python
result = {
    '占機': {'日時': str, 'タイムスタンプ': float},
    '占的': str,
    '状況整理': str,
    '得卦': {
        '番号': int,
        '名前': str,
        '読み': str,
        'シンボル': str,
        'バイナリ': str,
        '卦辞': str,
        '上卦': {'名前': str, '象意': str, '性質': str},
        '下卦': {'名前': str, '象意': str, '性質': str}
    },
    '得爻': {
        '番号': int,
        '名前': str,
        '陰陽': str,
        '爻辞': str
    }
}
```
-->

## 占機
`result['占機']['日時']`

## 占的
> `result['占的']`

## 状況整理
`result['状況整理']`

---

## 得卦
### 【`result['得卦']['番号']`】`result['得卦']['名前']`（`result['得卦']['読み']`）`result['得卦']['シンボル']`

**卦の構成**
- 上卦：`result['得卦']['上卦'].get('名前', '不明')`（`result['得卦']['上卦'].get('象意', '')`）- `result['得卦']['上卦'].get('性質', '')`
- 下卦：`result['得卦']['下卦'].get('名前', '不明')`（`result['得卦']['下卦'].get('象意', '')`）- `result['得卦']['下卦'].get('性質', '')`
- バイナリ表現：`result['得卦']['バイナリ']`

**卦辞**
> `result['得卦']['卦辞']`

**卦辞解釈**
（ここにClaudeが卦辞の和訳と現代的解釈を記載）

---

## 得爻
### 第`result['得爻']['番号']`爻 - `result['得爻']['名前']`（`result['得爻']['陰陽']`爻）

**爻辞**
> `result['得爻']['爻辞']`

**爻辞解釈**
（ここにClaudeが爻辞の和訳と現代的解釈を記載）

---

## 占断

### 現況分析
（ここにClaudeが現在の状況についての易経的洞察を記載）

### 展開予測
（ここにClaudeが今後の流れについての予測を記載）

### 行動指針
（ここにClaudeが具体的な行動提案を記載）

### 時機判断
（ここにClaudeがタイミングについての助言を記載）

---

## 軍師としての献策

（ここにClaudeが占的に対する戦略的な助言と総合的な指針を記載）

### 留意事項
（ここにClaudeが特に注意すべき点や補足情報を記載）

---

*易は変化の書なり。示された道は可能性の一つに過ぎず、*
*最終的な選択と行動は、あなた自身の意志による。*