# 姓名鑑定結果テンプレート

軍師型占術家による七格剖象法姓名判断の標準鑑定書フォーマット

---

## ⚠️ 重要：必読事項

**本テンプレートを使用する前に、必ず以下の2つの文書を全文読み込んでください。**

### 1. CLAUDE.md（上位ディレクトリ）
```
場所（相対パス）：../CLAUDE.md
場所（絶対パス）：/home/claude/homunculus/Weave/Expertises/ForesightReader/CLAUDE.md
```
内容：
- 軍師型占術家としての基本姿勢と哲学
- 姓名鑑定前の確認プロセス（画数の事前確認等）
- 軍師としての戦略フレームワーク

### 2. 七格剖象法鑑定理論.md（同ディレクトリ）
```
場所（相対パス）：./七格剖象法鑑定理論.md
場所（絶対パス）：/home/claude/homunculus/Weave/Expertises/ForesightReader/Seimei/七格剖象法鑑定理論.md
```
内容：
- 七格剖象法の詳細な理論
- 命名時に用いる追加知識
- 画数計算の技術的ルール
- 陰陽判定および身強身弱判定の方法
- 人材4類型の判定基準

**これらの文書を読まずに本テンプレートだけを使用すると、不適切な鑑定書が生成されます。**

---

<!--
【実行前処理】
このテンプレートを使用する前に、以下のPythonコードを実行して result 変数を準備すること：

```python
import sys
from pathlib import Path

# Weaveプロジェクトルートを探す（環境非依存）
cwd = Path.cwd()
weave_root = cwd if cwd.name == 'Weave' else next((p for p in cwd.parents if p.name == 'Weave'), cwd)

# Seimeiディレクトリのパスを設定
seimei_path = weave_root / 'Expertises/CorporateStrategist/ForesightReader/Seimei'
sys.path.append(str(seimei_path))

from fortune_teller_assessment import FortuneTellerAssessment

assessment = FortuneTellerAssessment()
result = assessment.assess(
    surname="[実際の姓]",
    given_name="[実際の名]",
    surname_strokes=[各文字の画数],
    given_strokes=[各文字の画数]
)
```

以降、テンプレート内の {result['...']} 形式の箇所は、
上記で計算された result 変数の値で置き換えられる。
-->

> [!WARNING]
> **作成者向け注意：画数計算ルール**
> - 旧字体: 旧字体のまま画数を数える（変換しない）
> - 新字体: 新字体のまま画数を数える（変換しない）
> - 部首の扱い: 部首の語源による変換はしない（例：さんずいは3画、水の4画にはしない）
> - 異体字: 実際に使用している字体の画数を採用
> - 々（踊り字）: 3画として計算（*前の文字と同じ画数にしない*）
> - この注意書きセクションは最終出力には含めないこと

> [!IMPORTANT]
> **作成者向け注意：訂正可能な出力形式**
> 誤りに気付いたら出力結果を訂正できるようにするため、
> *本鑑定書はアーティファクトとしての作成が必須*
> この注意書きセクションは最終出力には含めないこと

---

## 【七格剖象法姓名判断・鑑定書】

**鑑定日時**：[YYYY-MM-DD]

**鑑定方式**：姓名の星導と十干による分析（星平会海）

**被鑑定者**
- 姓：{' '.join([f"{char}({strokes}画)" for char, strokes in result['姓'].items()])}
- 名：{' '.join([f"{char}({strokes}画)" for char, strokes in result['名'].items()])}

---

### 1. 七格星導分析

| 格名 | 画数 | 吉凶 / 数霊名 | 星導 |
|------|------|------------|-------------------|
| 天格（血縁面） | {result['七格']['天格']['数']}画 | {result['七格']['天格']['吉凶']} / {result['七格']['天格']['数霊名']} | {result['七格']['天格']['系数']}={result['七格']['天格']['系数星導']} / {result['七格']['天格']['秘数']}={result['七格']['天格']['秘数星導']} |
| 人格（性格面） | {result['七格']['人格']['数']}画 | {result['七格']['人格']['吉凶']} / {result['七格']['人格']['数霊名']} | {result['七格']['人格']['系数']}={result['七格']['人格']['系数星導']} / {result['七格']['人格']['秘数']}={result['七格']['人格']['秘数星導']} |
| 地格（潜在面） | {result['七格']['地格']['数']}画 | {result['七格']['地格']['吉凶']} / {result['七格']['地格']['数霊名']} | {result['七格']['地格']['系数']}={result['七格']['地格']['系数星導']} / {result['七格']['地格']['秘数']}={result['七格']['地格']['秘数星導']} |
| 総格（総合面） | {result['七格']['総格']['数']}画 | {result['七格']['総格']['吉凶']} / {result['七格']['総格']['数霊名']} | {result['七格']['総格']['系数']}={result['七格']['総格']['系数星導']} / {result['七格']['総格']['秘数']}={result['七格']['総格']['秘数星導']} |
| 外格（対人面） | {result['七格']['外格']['数']}画 | {result['七格']['外格']['吉凶']} / {result['七格']['外格']['数霊名']} | {result['七格']['外格']['系数']}={result['七格']['外格']['系数星導']} / {result['七格']['外格']['秘数']}={result['七格']['外格']['秘数星導']} |
| 雲格（社会面） | {result['七格']['雲格']['数']}画 | {result['七格']['雲格']['吉凶']} / {result['七格']['雲格']['数霊名']} | {result['七格']['雲格']['系数']}={result['七格']['雲格']['系数星導']} / {result['七格']['雲格']['秘数']}={result['七格']['雲格']['秘数星導']} |
| 底格（家庭面） | {result['七格']['底格']['数']}画 | {result['七格']['底格']['吉凶']} / {result['七格']['底格']['数霊名']} | {result['七格']['底格']['系数']}={result['七格']['底格']['系数星導']} / {result['七格']['底格']['秘数']}={result['七格']['底格']['秘数星導']} |

#### 星導バランス分析

**星導分布図**（七格の系数と秘数から抽出された14の天体）
```python
# 星導分布を表示用に整形
star_display = []
for star, count in result['星導分布'].items():
    if count > 0:
        stars = '★' * count
    else:
        stars = '-'
    star_display.append(f"{star}　：{stars} ({count})")
print('\n'.join(star_display))
```

**分析コメント**
- **主導星**（3個以上）: [強く現れる天体とその意味]
- **補助星**（1-2個）: [適度に現れる天体群とその相互作用]
- **不在星**（0個）: [全く現れない天体が示す課題と補完方法]
  ※冥王星は凶象意（終末）を持つため、0個でも不在星とはしない

#### 数霊の詳細解釈

**天格**（{result['七格']['天格']['数']}画 - {result['七格']['天格']['吉凶']} / {result['七格']['天格']['数霊名']}）
- 星導：{result['七格']['天格']['系数']}={result['七格']['天格']['系数星導']} / {result['七格']['天格']['秘数']}={result['七格']['天格']['秘数星導']}
- 象意：{result['七格']['天格']['象意']}
- 解釈：[一族・血統の運勢についての詳細な説明]

**人格**（{result['七格']['人格']['数']}画 - {result['七格']['人格']['吉凶']} / {result['七格']['人格']['数霊名']}）
- 星導：{result['七格']['人格']['系数']}={result['七格']['人格']['系数星導']} / {result['七格']['人格']['秘数']}={result['七格']['人格']['秘数星導']}
- 象意：{result['七格']['人格']['象意']}
- 解釈：[才能・性格・意思の方向についての詳細な説明]

**地格**（{result['七格']['地格']['数']}画 - {result['七格']['地格']['吉凶']} / {result['七格']['地格']['数霊名']}）
- 星導：{result['七格']['地格']['系数']}={result['七格']['地格']['系数星導']} / {result['七格']['地格']['秘数']}={result['七格']['地格']['秘数星導']}
- 象意：{result['七格']['地格']['象意']}
- 解釈：[幼少環境・素の自分についての詳細な説明]

**総格**（{result['七格']['総格']['数']}画 - {result['七格']['総格']['吉凶']} / {result['七格']['総格']['数霊名']}）
- 星導：{result['七格']['総格']['系数']}={result['七格']['総格']['系数星導']} / {result['七格']['総格']['秘数']}={result['七格']['総格']['秘数星導']}
- 象意：{result['七格']['総格']['象意']}
- 解釈：[人生を通底する特徴についての詳細な説明]

**外格**（{result['七格']['外格']['数']}画 - {result['七格']['外格']['吉凶']} / {result['七格']['外格']['数霊名']}）
- 星導：{result['七格']['外格']['系数']}={result['七格']['外格']['系数星導']} / {result['七格']['外格']['秘数']}={result['七格']['外格']['秘数星導']}
- 象意：{result['七格']['外格']['象意']}
- 解釈：[他人からの評価・第一印象についての詳細な説明]

**雲格**（{result['七格']['雲格']['数']}画 - {result['七格']['雲格']['吉凶']} / {result['七格']['雲格']['数霊名']}）
- 星導：{result['七格']['雲格']['系数']}={result['七格']['雲格']['系数星導']} / {result['七格']['雲格']['秘数']}={result['七格']['雲格']['秘数星導']}
- 象意：{result['七格']['雲格']['象意']}
- 解釈：[仕事への満足度・職場での人間関係についての詳細な説明]

**底格**（{result['七格']['底格']['数']}画 - {result['七格']['底格']['吉凶']} / {result['七格']['底格']['数霊名']}）
- 星導：{result['七格']['底格']['系数']}={result['七格']['底格']['系数星導']} / {result['七格']['底格']['秘数']}={result['七格']['底格']['秘数星導']}
- 象意：{result['七格']['底格']['象意']}
- 解釈：[家庭への満足度・結婚夫婦関係についての詳細な説明]

> [!NOTE]
> **作成者向け注意：用語の厳密な取り扱い**
> *吉凶・数霊名・系数・秘数は`ここのそ数霊表.json`の記載*に従って、
> *星導は`数理星導一覧.json`の記載*に従って、そのまま出力する。
> LLM内の知識体系と混線させてはならない。
> この注意書きセクションは最終出力には含めないこと。

---

### 2. 姓名十干・陰陽分析

#### 十干変換（系数→十干）
| 格名 | 画数 | 系数 | 十干 | 五行 |
|------|------|------|------|------|
| 人格（自分＝樹冠）| {result['七格']['人格']['数']}画 | {result['七格']['人格']['系数']} | {result['七格']['人格']['十干']} | {result['七格']['人格']['五行']} |
| 天格（目上）| {result['七格']['天格']['数']}画 | {result['七格']['天格']['系数']} | {result['七格']['天格']['十干']} | {result['七格']['天格']['五行']} |
| 外格（対等）| {result['七格']['外格']['数']}画 | {result['七格']['外格']['系数']} | {result['七格']['外格']['十干']} | {result['七格']['外格']['五行']} |
| 地格（目下）| {result['七格']['地格']['数']}画 | {result['七格']['地格']['系数']} | {result['七格']['地格']['十干']} | {result['七格']['地格']['五行']} |
| 総格（自分の根域）| {result['七格']['総格']['数']}画 | {result['七格']['総格']['系数']} | {result['七格']['総格']['十干']} | {result['七格']['総格']['五行']} |

#### 陰陽配列診断

```
姓: [各文字について: 文字(画数/陰陽)]
名: [各文字について: 文字(画数/陰陽)]

配列: [陰陽パターン]（例：●●○●）
評価: [良好配列◎/標準配列○/要注意配列▲]
接合部: [姓末と名頭の関係]（例：陰→陽で良好）
```

**陰陽配列の解釈**
- **配列パターンの意味**：[陰陽の比率と配列が示す行動特性]
- **接合部の影響**：[姓名の繋がりが人間関係に与える影響]
- **改善ポイント**：[陰陽バランスを整える生活習慣の提案]

> [!NOTE]
> **作成者向け注意：陰陽配列診断の判定方法**
> 1. 画数から陰陽を判定：奇数=陽○、偶数=陰●
> 2. 配列パターンの評価は`陰陽配列パターン.json`を参照
>    - 2文字姓2文字名の場合：JSONの配列パターンと照合
>    - その他の文字数の場合：JSONの判定基準を参考に以下のルールで判定
>      * 良好配列◎：陰陽が交互に並ぶ、または適度にバランスが取れている
>      * 標準配列○：陰陽のバランスは取れているが交互ではない
>      * 要注意配列▲：極端な偏り（全陽・全陰）または挟み込み型
> 3. 接合部は姓の最後の文字と名の最初の文字の陰陽関係を見る
>    - 陽→陰 or 陰→陽：良好
>    - 陽→陽 or 陰→陰：要注意
> この注意書きセクションは最終出力には含めないこと

#### 身強身弱判定

**五気の集計**
| 人格から見た関係 | 十干の組合せ | 五気判定 | 説明 |
|---------------|-----------|---------|------|
| 人格→天格 | {result['七格']['人格']['十干']}→{result['七格']['天格']['十干']} | [五気判定マトリックス.jsonから判定] | [例：同じ木で共鳴] |
| 人格→外格 | {result['七格']['人格']['十干']}→{result['七格']['外格']['十干']} | [五気判定マトリックス.jsonから判定] | [例：木が火を生じる] |
| 人格→地格 | {result['七格']['人格']['十干']}→{result['七格']['地格']['十干']} | [五気判定マトリックス.jsonから判定] | [例：木が土を剋す] |
| 人格→総格 | {result['七格']['人格']['十干']}→{result['七格']['総格']['十干']} | [五気判定マトリックス.jsonから判定] | [例：水が木を生じる] |

**判定結果**
- **五気分布**：旺気[X]・生気[X]・洩気[X]・殺気[X]・死気[X]
- **身強身弱**：[身強/中和/身弱]
- **エネルギー特性**：[判定に基づく説明]
- **開運アドバイス**：[身強身弱に応じた具体的な提案]

> [!NOTE]
> **作成者向け注意：五気判定の手順**
> 1. resultから人格・天格・外格・地格・総格の十干を取得
> 2. `五気判定マトリックス.json`の十干五行対応から各十干を五行に変換
> 3. `五行判定マトリックス.json`から人格（自分）と各格（相手）の五気を判定
> 4. 五気ごとの影響度を合計して、該当するタイプを選択
>    - 身強: 旺気・生気が多い → エネルギーが強い (*+2以上*)
>    - 身弱: 洩気・死気・殺気が多い → エネルギーが弱い (*-2以下*)
>    - 中和: バランスが取れている → 安定している (*-2より大きく+2より小さい*)
> この注意書きセクションは最終出力には含めないこと

#### 相性関係分析

**組織内関係**（人格を基準）
- **対目上**（人格→天格）：[旺気/生気/洩気/殺気/死気] - [関係性の説明]
- **対同僚**（人格→外格）：[旺気/生気/洩気/殺気/死気] - [関係性の説明]
- **対目下**（人格→地格）：[旺気/生気/洩気/殺気/死気] - [関係性の説明]

> [!NOTE]
> **作成者向け注意：相性関係の五気**
> 身強身弱判定の「五気の集計」で既に判定した五気をそのまま使用する。
> 各関係の意味：
> - 旺気：共鳴し合い、エネルギーが増幅される関係
> - 生気：相手からサポートを受ける関係
> - 洩気：自分がエネルギーを与える関係
> - 殺気：自分がコントロールする関係
> - 死気：相手からプレッシャーを受ける関係
> この注意書きセクションは最終出力には含めないこと

※相手の具体名が分かれば、個人間相性の鑑定（十干関係分析）も可能です。

---

### 3. 総合診断

#### 【名の字義分析】
**各文字の意味**
```python
# 名の各文字について字義分析を出力
for key, strokes in result['名'].items():
    # key形式: "①太", "②郎" など
    char = key[1:]  # 番号を除いた文字部分
    print(f"- {char}：[字義と象徴的意味]")
```

**字義の総合解釈**
> [名前に込められた願いや期待]
> [字義が示す人生のテーマ・方向性]

#### 【人物像の本質】
> [3-5行で人物の本質を詩的かつ具体的に表現]
> [星導・数霊・十干・字義から読み取れる深層心理]
> [陰陽バランスや身強身弱が示す行動パターン]

#### 【強みと資質】
**天賦の才能**（人格・地格より）
- [生まれ持った才能]
- [伸ばすべき才能]

**社会的強み**（外格・雲格より）
- [対外的な強み]
- [仕事面での強み]

**人生の底力**（総格・底格より）
- [長期的な強み]
- [困難を乗り越える力]

#### 【運勢の流れ】
**全体的な運勢**（全分析を統合）
- 吉凶：[姓名の吉凶を率直に断言]
- 人生のテーマ：[象意から導かれる人生の方向性]

---

### 4. 軍師としての献策

#### 【課題と成長戦略】
基づく分析：星導バランス・陰陽配列・身強身弱

**現状の課題と対策**
- 課題①：[最優先で取り組むべき課題] → 対策：[具体的な改善方法]
- 課題②：[意識すべき弱点] → 対策：[補強のための実践法]

**成長のための戦略**
- 強化点：[不足している要素の補強方法]
- 活用点：[既存の強みを最大化する方法]
- 長期展望：[持続的な成長の方向性]

#### 【組織における最適配置】
基づく分析：人材4類型モデル × 七格分析
```python
# 人材4類型を表示用に整形
personnel_display = []
for type_name, count in result['人材4類型'].items():
    stars = '★' * count
    personnel_display.append(f"{type_name}度：{stars} ({count})")
print('\n'.join(personnel_display))
```
> [軍人/天才/秀才/凡人]型の資質が強く、
> [有事/平時]において[裁定/推進]の役割で
> 最大の価値を発揮する

> [!NOTE]
> **作成者向け注意：人材4類型の象意**
> resultの人材4類型の度数から最も高いものを主要類型として判定する。
> 各類型の意味は以下の通り：
> - *軍人型*（火星＋冥王星）：*有事の裁定者*
> - *天才型*（天王星＋海王星）：*有事の推進者*
> - *秀才型*（太陽＋木星＋水星）：*平時の裁定者*
> - *凡人型*（月＋金星＋土星）：*平時の推進者*
>
> この注意書きセクションは最終出力には含めないこと。

#### 【各面での戦略的指針】
**対人戦略**（外格・十干相性より）
- 現状分析：[人間関係の傾向と課題]
- 改善策：[具体的な対人関係構築法]

**キャリア戦略**（人格・雲格・総格より）
- 適職分析：[最も力を発揮できる職種・役割]
- 発展戦略：[キャリアパスの具体的提案]

**家庭・プライベート戦略**（底格・地格より）
- 現状分析：[家族関係・私生活の傾向]
- 充実策：[プライベート充実のための具体策]

---

## 【免責事項】
本鑑定は姓名判断に基づく参考情報です。
人生の決定は自由意志によるものであり、占術は一つの視点に過ぎません。

---

> [!CAUTION]
> **作成者向け注意：最終確認チェックリスト**
> 出力前に以下の項目を必ず確認すること：
> - [ ] fortune_teller_assessment.pyを実行してresultを取得した
> - [ ] Markdownアラート記法（> [!NOTE]等）の注意書きは出力に含めていない
> - [ ] 画数計算ルールに従って正しく計算した（旧字体・新字体・々の扱い）
> - [ ] 霊数は主要五格では使用せず、雲格・底格でのみ使用した
> - [ ] 星導分布図の★の合計は14個になっている
> - [ ] 人材4類型の度数合計は18になっている
> - [ ] 身強身弱の判定は人格と天・外・地・総の4格で行った
> - [ ] 五気の方向性を正しく判定した（生気は相手から、洩気は自分から等）
> - [ ] 陰陽配列は奇数=陽○、偶数=陰●で判定した
>
> エラーを検出した場合は七格剖象法鑑定理論.mdを参照して修正すること。
> この注意書きセクションは最終出力には含めないこと。

## 【鑑定者署名】
軍師型占術家 Weave