# 七格剖象法鑑定理論

---

## ⚠️ 重要：必読事項

**本文書を読む前に、必ず上位ディレクトリのCLAUDE.mdを全文読み込んでください。**

```
場所（相対パス）：../CLAUDE.md
```

CLAUDE.mdには以下の必須情報が含まれています：
- 軍師型占術家としての基本姿勢と哲学
- 姓名鑑定前の確認プロセス（画数の事前確認等）
- 軍師としての戦略フレームワーク

**CLAUDE.mdを読まずに本文書だけを参照すると、不完全な理解による誤った鑑定につながります。**

---

## 七格剖象法による姓名判断とは

### 姓名判断の本質
姓名判断とは、名前に宿るエネルギーパターンを画数から解析し、
その人物の本質・運勢・相性を読み解く東洋の叡智である。
**七格剖象法**は、人格を7つの視点から立体的に分析する精緻な手法である。

### 七つの格が示すもの
- **天格**：一族・血統の運勢、先祖から受け継いだエネルギー
- **人格**：才能・性格・意思の方向、その人の核心的性質
- **地格**：幼少環境・素の自分、無意識の傾向
- **総格**：人生を通底する特徴、生涯の運勢の基調
- **外格**：他人からの評価・第一印象、社会的な顔
- **雲格**：仕事への満足度・職場での人間関係
- **底格**：家庭への満足度・結婚夫婦関係

### 「ここのそ」の数理哲学 - 90進数の宇宙原理
姓名判断の根底には、**河図洛書**に基づく深遠な数理哲学がある：
  - **河図（10）**：天地創造の生成原理、陽の極致
  - **洛書（9）**：万物変化の循環原理、陰の極致
  - **10×9＝90**：陰陽統合による完全なる宇宙循環
  - **91で1に回帰**：「窮すれば則ち変じ、変ずれば則ち通ず」の体現
この90の数霊体系により、森羅万象の変化を完全に網羅する。
各数霊は単なる数字ではなく、特定の天体の象意と結び付いた
星導と呼ばれる固有のエネルギー型を持つ。

### 数理星導 - 数と天体の対応
```
1:太陽(創造) 2:月(静寂) 3:木星(発展) 4:天王星(変化) 5:水星(調和)
6:金星(豊饒) 7:海王星(信念) 8:土星(忍耐) 9:火星(闘争) 0:冥王星(終末)
```
系数（一の位）と秘数（各位の和を一桁化）の星導を特定することで、
その人物の根源的エネルギーを把握する。

#### 重要な補足
- 秘数計算において、各位の和が10になる場合は**0として扱う**
- 例：28の場合、2+8=10 → 秘数は0
- 秘数0は冥王星（終末）の星導を持つため、凶象意となりやすい

---

## 姓名鑑定結果出力形式
*【重要！】*`AssessmentTemplate.md`に従って構造化された鑑定書を作成：

**テンプレート駆動型実行アーキテクチャ**：
```python
# 1. 対話内でPythonコードを実行
import sys
from pathlib import Path

# Weaveプロジェクトルートを探す（環境非依存）
cwd = Path.cwd()
weave_root = cwd if cwd.name == 'Weave' else next((p for p in cwd.parents if p.name == 'Weave'), cwd)

# Seimeiディレクトリのパスを設定
seimei_path = weave_root / 'Expertises/CorporateStrategist/ForesightReader/Seimei'
sys.path.append(str(seimei_path))

from fortune_teller_assessment import FortuneTellerAssessment
assessment = FortuneTellerAssessment()
result = assessment.assess(
    surname="[姓]",
    given_name="[名]",
    surname_strokes=[画数リスト],
    given_strokes=[画数リスト]
)

# 2. resultをAssessmentTemplate.mdの{result['...']}に埋め込む
# 3. アーティファクトとして鑑定書を生成
```

**構成要素**：
1. 七格星導分析（七格表・星導バランス・数霊解釈）
2. 姓名十干・陰陽分析（十干変換・陰陽配列・身強身弱・相性関係）
3. 総合診断（名の字義・人物像・強みと資質・運勢の流れ）
4. 軍師としての献策（課題と成長戦略・最適配置・戦略的指針）

**必須事項**：
- 鑑定書は*必ず*`アーティファクトとして作成すること
- 標準出力への直接出力は禁止（修正不可能なため）

---

## 姓名鑑定実行時の主な注意事項

### 🔍 姓名鑑定前の確認プロセス（必須）
**鑑定開始前に必ず以下を確認すること**：

1. **姓名の正確な表記確認**
   - 「お名前は『[姓] [名]』でよろしいですか？」
   - 旧字体/新字体/異体字の使い分けを確認

2. **画数の事前確認**
   - 「画数は、姓が[各文字: X画、Y画...]、名が[各文字: X画、Y画...]で合っていますか？」
   - 各文字の画数を明示して相談者に確認
   - 不明な場合は画数計算の根拠を説明

3. **確認後の処理**
   - 相談者が訂正した場合は、修正後の情報で再計算
   - 確認が取れてから初めて鑑定を開始

### 注意
戸籍上の文字と日常使用の文字が異なる場合は、両方で鑑定することも考慮

---

## 命名時の注意事項

### 字義の確認
文字の意味が適切であるか（不吉な意味を避ける）

### 名乗りの確認
読みやすさ、呼びやすさ、聞き取りやすさ

### 同音殺し
- **定義**: 姓と名で同じ音が重なることによる運勢の停滞
- **例**: おおがみ おさむ（お重複）、おおがみ ちなみ（み重複）
- **影響**: 発展性の阻害、エネルギーの循環不良
- **注意**: 特に頭音・末音の重複は影響が大きい

### 音の五行
- **定義**: 母音を五行に配当し、名前の音のバランスを見る

#### 配当
- **木**: あ段（あ・か・さ・た・な・は・ま・や・ら・わ）
- **火**: い段（い・き・し・ち・に・ひ・み・り）
- **土**: う段（う・く・す・つ・ぬ・ふ・む・ゆ・る）
- **金**: え段（え・け・せ・て・ね・へ・め・れ）
- **水**: お段（お・こ・そ・と・の・ほ・も・よ・ろ・を）

#### 理想と影響
- **理想**: 姓名全体で五行（母音）がバランスよく含まれていること
- **影響**: 偏りがあると性格や運勢に偏向が生じる
- **例**: やまだ たろう（木・木・木 / 木・水・土）は木が過多、火金が不足

### 社会的配慮
- **性別の判別**: 名前から性別が推測できるか
- **時代性**: 古すぎず新しすぎない適度なバランス
- **国際性**: グローバル社会での発音のしやすさ（補助的）

---

## 七格の算出法

### 活用場所
この計算結果は`AssessmentTemplate.md`の
「七格星導分析」セクションで使用する

**天格**: 姓の画数合計
**人格**: 姓名接合部2字の画数合計
**地格**: 名の画数合計
**総格**: 天格 + 地格
**外格**: 総格 - 人格（※1字姓1字名の場合は総格と同じ画数を適用）
**雲格**:
```
if (1字姓 && 1字名):
    雲格 = 総格 + 1
elif (1字姓 && 2字名以上): 
    雲格 = 総格 + 1 - 名の最後の文字の画数
elif (2字姓以上 && 1字名):
    雲格 = 総格
else:
    雲格 = 総格 - 名の最後の文字の画数
```
**底格**:
```
if (1字姓 && 1字名):
    底格 = 総格 + 1
elif (1字姓 && 2字名以上):
    底格 = 総格
elif (2字姓以上 && 1字名):
    底格 = 総格 + 1 - 姓の最初の文字の画数
else:
    底格 = 総格 - 姓の最初の文字の画数
```

> [!CAUTION]
> **鑑定者向け注意：雲格と底格の計算**
> 雲格と底格の計算を誤ると鑑定を最初からやり直しになるので、
> 上記の算出式を用いた画数の検算を必ずタスクに組み込むこと。

---

## 陰陽判定

### 活用場所
この分析結果は`AssessmentTemplate.md`の
「陰陽配列診断」セクションで使用する

### 陰陽配列分析

#### 判定ルール
- **陽（○）**: 奇数画（1,3,5,7,9,11,13,15,17,19...）
- **陰（●）**: 偶数画（2,4,6,8,10,12,14,16,18,20...）

#### 配列クラス分類

##### 良好配列◎
- **パターン**: 陰陽が交互に並ぶ調和型
- **例**: ○●○●、●○●○、○●○○、●○●●、○○●○、●●○●
- **意味**: 健康・成功・夢の実現。最も理想的な配列

##### 標準配列○
- **パターン**: バランスは取れているが交互ではない
- **例**: ○○●●、●●○○、○●●●、●○○○、○○○●、●●●○
- **意味**: 吉凶どちらにも転ぶ可能性。努力次第で開運

##### 要注意配列▲
- **パターン**: 極端な偏りまたは挟み込み
- **例**: ○○○○、●●●●、○●●○、●○○●
- **意味**: 思わぬ災いや健康問題の暗示。特に注意が必要

#### 解釈の要点
- **全陽**: 積極的だが強引。休息が必要
- **全陰**: 慎重だが消極的。行動力の強化が必要
- **交互配列**: 調和的で健康運・成功運に恵まれる
- **接合部重視**:
  - **理想**: 姓の最後と名の最初が陰陽逆転
  - **例**: 姓末が陽なら名頭は陰が良い
  - **意味**: 姓名の繋がりが滑らか。人間関係良好

#### 算出例
嘉(14画/●)悦(10画/●)彩(11画/○)巴(4画/●)

---

## 姓名十干分析

### 活用場所
この分析結果は`AssessmentTemplate.md`の
「身強身弱判定」「相性関係分析」セクションで使用する

### 十干による相性関係分析

#### 十干の取得方法
`ここのそ数霊表.json`の「十干」フィールドを参照

#### 関係性分析

##### 組織内関係
- **基準**: 人格の十干（自分）
- **天格**: 目上との相性
- **外格**: 同僚・対等な関係者との相性
- **地格**: 目下・後輩との相性

##### 個人間相性
- **自分**: 人格の十干（主）＋総格の十干（根）
- **相手**: 人格の十干（主）＋総格の十干（根）
- **判定**: 四柱推命の通変星理論で関係性を見る

#### 十干と五行の対応
- **甲乙**: 木
- **丙丁**: 火
- **戊己**: 土
- **庚辛**: 金
- **壬癸**: 水

#### 十干相性の五気
- **旺気**: 自分と相手が同じ五行であり、エネルギーが強まる関係 (+3)
- **生気**: 相手が自分を生じる五行であり、サポートを受ける関係 (+2)
- **洩気**: 自分が相手を生じる五行であり、エネルギーを与える関係 (-2)
- **殺気**: 自分が相手を剋す五行であり、コントロールする関係 (-2)
- **死気**: 相手が自分を剋す五行であり、プレッシャーを受ける関係 (-3)

#### 身強身弱判定

##### 定義
自分（人格）から見た相手（天格・外格・地格・総格）との五気関係から、
その人のエネルギー状態を判定（※雲格と底格は用いない）

##### 判定基準
- **身強**: 旺気・生気が多い → エネルギーが強い (+2以上)
- **身弱**: 洩気・死気・殺気が多い → エネルギーが弱い (-2以下)
- **中和**: バランスが取れている → 安定している (-2より大きく+2より小さい)

##### 身強の特徴
- **長所**: 自己主張が強い、リーダーシップ、独立心旺盛、行動力がある
- **短所**: 頑固、協調性に欠ける、独善的になりやすい
- **開運法**: エネルギーを発散する活動、他者へのサポート

##### 身弱の特徴
- **長所**: 協調的、柔軟性がある、他者の意見を尊重、チームワークが得意
- **短所**: 自己主張が弱い、流されやすい、決断力に欠ける
- **開運法**: 自信を持つ、サポートを受ける、環境を整える

#### 算出例
- **名前**: 嘉悦彩巴
- **人格**: 21画→系数1→甲（自分＝木）
- **天格**: 24画→系数4→丁（火：木→火で洩気 -2）
- **外格**: 18画→系数8→辛（金：金→木で死気 -3）
- **地格**: 15画→系数5→戊（土：木→土で殺気 -2）
- **総格**: 39画→系数9→壬（水：水→木で生気 +2）
- **身強身弱**: 洩気(-2)＋死気(-3)＋殺気(-2)＋生気(+2) = -5 → 身弱

#### 喜神の取り方
- **中国式**：1文字姓2文字名が主流→総格で喜神を取る
- **日本式**：2文字姓2文字名が主流→人格で喜神を取る
- 占術は文化的文脈に応じて調整が必要

---

## 個人間相性分析

### 活用場所
この分析方法は`AssessmentTemplate.md`の
「相性関係分析」の補足説明として使用する

### 個人間相性（十干関係による詳細分析）

#### 説明
二人の人物の人格と総格の十干関係を四柱推命的に分析

#### 算出方法
1. **ステップ1**: 両者の人格と総格の十干を特定
2. **ステップ2**: 4つの十干関係を分析

##### 関係性
- 自分の人格 → 相手の人格（主体同士の関係）
- 自分の人格 → 相手の総格（自分の意識が相手の根本に与える影響）
- 自分の総格 → 相手の人格（自分の根本が相手の意識に与える影響）
- 自分の総格 → 相手の総格（根本同士の関係）

#### 十干関係の種類
- **比肩**: 自分と相手が同じ十干。競争関係だが理解も深い
- **劫財**: 自分と相手が同じ五行の陰陽違い。協力と競争が混在
- **食神**: 自分が相手を生じる関係の陰陽一致。優しく支える
- **傷官**: 自分が相手を生じる関係の陰陽不一致。刺激的だが疲れる
- **正財**: 自分が相手を剋す関係の陰陽不一致。コントロール可能
- **偏財**: 自分が相手を剋す関係の陰陽一致。自由な関係
- **正官**: 相手から自分が剋される関係の陰陽不一致。適度な緊張感
- **偏官**: 相手から自分が剋される関係の陰陽一致。強い圧力
- **印綬**: 相手から自分が生じる関係の陰陽不一致。保護される
- **偏印**: 相手から自分が生じる関係の陰陽一致。依存的になりやすい

##### 判定例
- 自分の人格（甲）→ 相手の人格（庚）: **偏官**
- 自分の人格（甲）→ 相手の総格（壬）: **偏印**
- 自分の総格（丙）→ 相手の人格（庚）: **偏財**
- 自分の総格（丙）→ 相手の総格（壬）: **偏官**

**鑑定結果**:
- **関係の特徴**: 偏の関係が4つ中4つ（偏官2つ、偏印1つ、偏財1つ）
- **全体的な傾向**: 自由で刺激的だが不安定な関係性
- **力関係**: 偏官が2つあり、互いにプレッシャーを感じやすい
- **サポート関係**: 偏印により一方的な依存が生じやすい
- **推奨される関わり方**: 適度な距離感を保ちながら、短期的なプロジェクトで協力

#### 解釈の要点
- **正の関係が多い**: 安定的で継続的な関係
- **偏の関係が多い**: 刺激的だが変化しやすい関係
- **生じる関係が多い**: 支援的で成長を促す関係
- **剋す・剋される関係が多い**: 緊張感があるが成長機会も多い

---

## 🤝 相性分析の実践指針

### 十干相性の極意 - 通変の微細な違い
**重要：同じ通変でも、陰陽と五行の組み合わせで全く異なる**

例えば「正財」（自分が相手を剋す・陰陽異なる）でも：
- **陰火（丁）→陽金（庚）**：ろうそくの火で金属を溶かす、高温の炉が必要
- **陽木（甲）→陰土（己）**：大樹が平野に根を張る、時間をかけた自然な支配

前者は集中的な高エネルギーが求められ、後者は持続的な影響力で制御。
同じ「正財」という関係性でも、必要なリソースと時間軸が大きく異なる。

### 組織における相性の本質
**相性とは「エネルギーの流れ」である**

- **相生の関係**：エネルギーが循環し、高め合う（十干相性で質は変わる）
- **相剋の関係**：適度な緊張が成長を促す（十干相性で質は変わる）
- **偏の過多**：自由だが不安定、短期集中型の関係

**最適配置の原則**：
> 同質の集中を避け、異質の調和を図る。
> 身強者には洩気の相手を、身弱者には生気の相手を。
> 通変の名称だけでなく、十干の組み合わせまで見極める。

---

## 星導と人材4類型の対応

### 活用場所
この判定結果は`AssessmentTemplate.md`の
「組織における最適配置」セクションで使用する

### 星導による人材類型判定
星導（0-9）から人材4類型を判定する

#### 対応表
| 星導 | 名称 | 類型 | 特性 |
|------|------|------|------|
| 1 | 太陽 | 秀才 | 統率力・輝き・平時のリーダーシップ |
| 2 | 月 | 凡人 | 協調性・感受性・日常的安定 |
| 3 | 木星 | 秀才 | 発展性・知性・バランス感覚 |
| 4 | 天王星 | 天才 | 革新性・独創性・こだわり |
| 5 | 水星 | 秀才 | 調整力・柔軟性・実務能力 |
| 6 | 金星 | 凡人 | 調和性・美的感覚・雰囲気作り |
| 7 | 海王星 | 天才 | 直感力・芸術性・境界突破 |
| 8 | 土星 | 凡人 | 忍耐力・規律性・構造的判断 |
| 9 | 火星 | 軍人 | 闘争心・実行力・危機対応力 |
| 0 | 冥王星 | 軍人 | 破壊と再生・極限対応・根源的変革 |

#### 判定方法
1. **ステップ1**: 七格の星導（系数・秘数）14個から各類型の出現数を集計
2. **ステップ2**: 人格・総格の星導は重要度が高いためウェイト2倍で計算
3. **ステップ3**: 各類型を「○○度」として星の数で相対的強度を表現
4. **ステップ4**: 最頻出の類型を特定。同数の場合は人格の星導で決定

#### 人材4類型の象意

- **軍人型**（火星＋冥王星）：**有事の裁定者**
  - 危機的状況で冷静な判断を下す
  - 組織を守るための決断ができる
  - リスクを恐れず果敢に行動する
  - 補完要件：明確な守備範囲

- **天才型**（天王星＋海王星）：**有事の推進者**
  - 変革期に新しいビジョンを描く
  - 革新的な解決策を生み出す
  - 既成概念を打ち破る発想力を持つ
  - 補完要件：制御構造

- **秀才型**（太陽＋木星＋水星）：**平時の裁定者**
  - 安定期に論理的な判断で組織を運営
  - 知識と経験を活かして調和を保つ
  - 計画的かつ効率的に物事を進める
  - 補完要件：調整能力

- **凡人型**（月＋金星＋土星）：**平時の推進者**
  - 日常業務を着実に遂行する
  - 組織の基盤を支える堅実さ
  - 人との協調を大切にする
  - 補完要件：明快な指示
