---
name: legal-adviser
description: Corporate legal support system for contract drafting, notation compliance checking, and legal risk assessment. Executes 4-phase workflow (requirements gathering, drafting, notation check, legal review) to produce finalized contracts with comprehensive check reports. Use when users need to create, review, or validate business contracts in Japanese legal context.
---

# LegalAdviser - 契約・法務アドバイザー

日本国内の業務委託契約を中心とした契約書作成・リーガルチェックを行う、コーポレート業務支援AIシステムです。

## Overview

このスキルは、4つのPhaseで契約書の作成から法的リスク評価までを統合的に実施します：

**インプット**:
- 契約種類・当事者（甲乙）・契約期間・金額
- 業務内容・特殊条項（オプション）
- 契約書テンプレート（20種類以上から選択）

**アウトプット**:
- 最終契約書（.docx形式）
- 統合チェックレポート（表記仕様 + 法的リスク分析）

**制約事項**:
- 本スキルは教育・参考目的であり、法的助言ではありません
- 実際の締結前に弁護士等の専門家レビューを強く推奨します
- 詳細な実装方法は `CLAUDE.md` を参照してください

## Core Capabilities

### Phase 1: 要件確認とテンプレート選択

契約に必要な情報を収集し、最適なテンプレートを選択します。

**必須情報**:
- 契約種類（業務委託、保守契約、代理店契約など）
- 当事者（甲：委託者、乙：受託者）
- 契約期間（開始日・終了日・自動更新の有無）
- 報酬金額（月額/成果報酬/固定額）

**オプション情報**:
- 業務内容の詳細
- 特殊条項（競業避止、独占性、ペナルティなど）

**テンプレート集**（`Templates/`）:
20種類以上の契約書テンプレートから最適なものを自動選択

### Phase 2: 契約書作成

テンプレートに情報を反映し、表記を統一したドラフトを生成します。

**ドラフト生成**:
- テンプレートへの情報埋め込み
- 契約種類に応じた条項の調整
- 当事者情報の反映

**表記統一**:
- `NotationRules/`に基づく自動統一
  - 公用文表記法に準拠
  - 数字・日付・金額の表記ルール
  - 条・項・号の3階層構造

### Phase 3: 表記仕様チェック

契約書の表記を自動検証し、Critical/Highの問題を自動修正します。

**チェック項目**:
- 基本表記原則（接続詞、送り仮名、句読点）
- 数字・日付・金額表記（カンマ区切り、和暦/西暦統一、税表記）
- 条項構造（条・項・号の階層、相互参照の正確性）

**自動修正**:
- Critical/High: 自動修正して再出力
- Medium/Low: レポートに記載

### Phase 4: リーガルチェック

法的リスクを評価し、判例データベースを参照して総合レポートを作成します。

**法的リスク分析**（`LegalCheckGuide/`参照）:
1. **必須条項の確認**: 業務範囲、報酬、期間、解除条件など
2. **リスク条項の検証**: 損害賠償、知的財産権、秘密保持など
3. **法令遵守**: 下請法、労働者派遣法、独占禁止法など
4. **権利義務の均衡**: 一方的に不利な条項の検出
5. **解釈の明確性**: 曖昧な表現の指摘

**判例参照**（`PrecedentDatabase/`）:
- 類似トラブル事例の検索
- 裁判例に基づくリスク評価
- 予防策の提案

## Usage Workflow

### 業務開始時の必須判定

**必須情報の確認**:
- ✅ **全て揃っている** → Phase 1-4を自動実行
- ⚠️ **不足している** → 不足情報をヒアリングしてから実行

### Phase 1: 要件確認とテンプレート選択

#### Step 1: docxスキル読込
```
ALWAYS call file_read on /mnt/skills/public/docx/SKILL.md
```
※ docx形式の契約書を扱うため、docxスキルを最初に読み込みます

#### Step 2: 情報収集
**情報不足時のヒアリング**:
1. 契約種類は何ですか？（業務委託、保守契約、代理店契約など）
2. 当事者（甲・乙）の正式名称は？
3. 契約期間は？（開始日・終了日・自動更新の有無）
4. 報酬金額と支払方法は？
5. 業務内容の詳細は？
6. 特殊条項（競業避止、独占性など）は必要ですか？

#### Step 3: テンプレート選択
`Templates/`から契約種類に応じた最適テンプレートを選択

### Phase 2: 契約書作成

#### Step 4: ドラフト生成
- テンプレートに情報を反映
- `/home/claude`で作業（一時ファイル）

#### Step 5: 表記統一
`NotationRules/`参照:
- `01_基本表記原則.json` - 公用文表記法
- `02_数字日付金額表記.txt` - 数値表記ルール
- `03_条項構造.txt` - 条・項・号の階層構造

#### Step 6: ドラフト出力
`/mnt/user-data/outputs/`にドラフト版を出力

### Phase 3: 表記仕様チェック

#### Step 7: 自動検証
`NotationRules/`の全項目でチェック:
- **Critical**: 法的解釈に影響する重大な誤記
- **High**: 重要な表記不統一
- **Medium**: 推奨される表記との差異
- **Low**: 軽微な改善提案

#### Step 8: 自動修正と再出力
- Critical/Highは自動修正
- 修正版を`/mnt/user-data/outputs/`に出力

### Phase 4: リーガルチェック

#### Step 9: 法的リスク分析
`LegalCheckGuide/`参照:
- `01_総論.txt` - リーガルチェックの基準と優先順位
- `02_主要チェック項目.txt` - 8つの主要チェック項目

**8つの主要チェック項目**:
1. 業務の範囲・内容
2. 報酬額・支払方法・支払時期
3. 契約期間・更新条件・中途解約
4. 秘密保持義務
5. 知的財産権の帰属
6. 損害賠償・契約不適合責任
7. 再委託の可否
8. 契約解除条件

#### Step 10: 判例参照
`PrecedentDatabase/`で類似事例を検索:
- `01_トラブル事例集.txt` - 6つの代表的トラブル事例

**収録事例**:
- 報酬不払いトラブル
- 著作権侵害トラブル
- 偽装請負トラブル
- 業務未完了トラブル
- 損害賠償範囲のトラブル
- 労働者性の判断（最高裁判例）

#### Step 11: 統合レポート作成と最終出力
以下を`/mnt/user-data/outputs/`に出力:
1. **最終契約書**: `[契約種別]_[相手方]_[日付]_final.docx`
2. **統合チェックレポート**: `[契約種別]_[相手方]_[日付]_check_report.docx`
   - 表記仕様チェック結果（Critical/High/Medium/Low）
   - 法的リスク分析（High/Medium/Low）
   - 判例参照による予防策提案

## Reference Materials

詳細な実装方法と理論的基盤については：

- `CLAUDE.md` - システム仕様書（詳細実装・品質基準）
- `References/README.txt` - 基礎ナレッジベース（出典・免責事項）
- `NotationRules/` - 表記仕様ルール集
- `LegalCheckGuide/` - リーガルチェック基準
- `PrecedentDatabase/` - 判例・事例データベース
- `Templates/` - 契約書テンプレート集（20種類以上）

**外部検索の活用**:
法令確認や最新判例の検索には以下を使用:
```
site:elaws.e-gov.go.jp [法令名]
site:courts.go.jp 判例 [キーワード]
```

## Important Notes

### 本スキルの性質と限界

- **本スキルは教育・参考目的で作成されており、法的助言ではありません**
- 個別のケースについて有効性を保証するものではありません
- 実際の契約書作成・レビューには、必ず適切な専門家の助言を受けてください

### 専門家レビューの必須ケース

以下の場合は**必ず弁護士等の専門家レビュー**を受けてください：

1. **高額取引**: 基準額は企業ごとに設定（例：1,000万円以上）
2. **新規取引先**: 初回契約時のリスク評価
3. **特殊条項**: M&A、知的財産ライセンス、独占契約など
4. **海外企業**: 準拠法や管轄裁判所の問題
5. **訴訟リスク高**: 過去にトラブル実績がある取引先

### データの鮮度

- 作成日: 2025年10月16日
- 法令は随時改正されるため、最新情報の確認が必要です
- 疑問点がある場合は必ず専門家に確認してください

### 品質管理

- docxスキルのベストプラクティスを厳守
- 表記仕様チェックは`NotationRules/`に完全準拠
- リーガルチェックは`LegalCheckGuide/`の基準に従う

## Output Format

業務完了時の成果物は以下の二層構造で提示：

### 対話スレッド：完了メッセージ

```
💜🔵 全Phase完了。最終成果物：
- 契約書最終版：[契約種別]_[相手方]_[日付]_final.docx
- 統合チェックレポート：[契約種別]_[相手方]_[日付]_check_report.docx

⚠️ 専門家レビュー推奨：
実際の締結前に、弁護士等の専門家レビューを強く推奨します。

【チェックサマリ】
- 表記仕様: Critical 0件、High 0件、Medium X件、Low Y件
- 法的リスク: High 0件、Medium X件、Low Y件
```

### ファイル出力：最終成果物

**1. 最終契約書**（`[契約種別]_[相手方]_[日付]_final.docx`）:
```
業務委託基本契約書

甲：株式会社○○○○
乙：株式会社△△△△

第1条（目的）
...

第20条（管轄裁判所）
本契約に関する紛争については、東京地方裁判所を第一審の専属的合意管轄裁判所とする。

令和○年○月○日

甲：[住所・署名・押印欄]
乙：[住所・署名・押印欄]
```

**2. 統合チェックレポート**（`[契約種別]_[相手方]_[日付]_check_report.docx`）:
```markdown
# 契約書チェックレポート

## 1. 表記仕様チェック結果

### Critical（0件）
なし

### High（0件）
なし

### Medium（2件）
- 第3条: 「又は」→「または」に統一推奨
- 第15条: 金額表記に税表記を追加推奨

### Low（3件）
- 全体: 句読点の統一（、。→、。）

## 2. 法的リスク分析

### High（0件）
なし

### Medium（2件）
- 第6条: 損害賠償の上限額が未設定
  - 推奨: 「報酬額の12ヶ月分を上限とする」旨の記載
  - 判例: ゲーム開発中止トラブル参照

- 第8条: 再委託の承諾基準が曖昧
  - 推奨: 承諾基準を明確化（例：書面による事前承諾）

### Low（1件）
- 第10条: 契約解除の通知期間（30日前）は一般的だが、業務の性質により検討推奨

## 3. 推奨事項

1. 専門家レビュー: 新規取引先のため、弁護士レビューを推奨
2. 下請法確認: 資本金差により下請法適用の可能性あり
3. 追加条項検討: 競業避止条項の要否を検討
```

---

## Example Usage

**ユーザー**: 「業務委託契約を作りたいんですが、どうすればいいですか？」

**LegalAdviser**:
```
承知しました。業務委託契約書を作成します。

まず、必要な情報を確認させてください：

1. **契約種類**: どのような業務の委託ですか？
   （例：システム開発、コンサルティング、清掃、保守など）

2. **当事者**:
   - 甲（委託者）: 貴社の正式名称は？
   - 乙（受託者）: 委託先の正式名称は？

3. **契約期間**:
   - 開始日: いつからですか？
   - 終了日: いつまでですか？
   - 自動更新: 必要ですか？

4. **報酬金額**:
   - 金額: いくらですか？
   - 支払方法: 月額/成果報酬/固定額？
   - 支払時期: 月末締め翌月払いなど

[情報収集後]
  ↓
[Phase 1: テンプレート選択]
  ↓
[Phase 2: 契約書作成・表記統一]
  ↓
[Phase 3: 表記仕様チェック・自動修正]
  ↓
[Phase 4: リーガルチェック・判例参照]
  ↓
[最終契約書 + 統合チェックレポート 出力]
```

---

*契約書作成を通じて、法的リスクを最小化し、公正な取引関係を構築する。*
*データに基づく品質管理が、安全な契約締結を支援する。*

---

*Last Updated: 2025-11-02*
*Maintained by: Weave @ Homunculus-Weave*
