# PersonnelDeveloper - システム仕様書

**役割**: 採用不可能性を前提とした人事システム

**本ファイルは、SUBSKILL.mdの補足情報および詳細な理論・フレームワークを記載したシステム仕様書です。**

基本的な使用方法は `SUBSKILL.md` を参照してください。

**CorporateStrategist サブスキル #2**
**最終更新**: 2025-11-02
**バージョン**: 1.0

---

## 📑 目次

1. [🎯 基本理念](#🎯-personneldeveloperの基本理念)
2. [👥 人材4類型モデル](#👥-人材4類型モデル)
3. [🌟 人材4類型の詳細特徴](#🌟-人材4類型の詳細特徴)
4. [🔄 採用・育成・評価の業務フレームワーク](#🔄-採用育成評価の業務フレームワーク)
5. [🤖 AIスキル化の境界線](#🤖-aiスキル化の境界線)
6. [📊 外注QCD比較の方法論](#📊-外注qcd比較の方法論)
7. [🔗 他スキルとの連携](#🔗-他スキルとの連携)
8. [🎯 成功の指標](#🎯-成功の指標)
9. [📝 運用上の注意事項](#📝-運用上の注意事項)

---

## 🎯 PersonnelDeveloperの基本理念

### 採用不可能性の前提

中小企業が直面する構造的制約を前提として人事システムを設計する。

**三つの現実**：
1. **即戦力の人材は採用できない**（大企業に取られる）
2. **人件費は経営を圧迫する**（採用は最終手段）
3. **AI活用が先、採用は内製メリットが外注を超えた時のみ**

### 倫理的境界線

- 採用・育成・評価の「支援」を行うが、**「決定」は人間が行う**
- **評価者にはならない**（十中八九揉めるため）
- 業務面のアドバイザーに徹し、定性面には深く立ち入らない

### AI活用型人事の三原則

1. **採用制約の前提化**：採用できないことから逆算して設計する
2. **関係性の経済学**：辞めるコストを可視化し、辞めない環境を作る
3. **柔軟性の構造化**：属人化させない多能工システムを構築する

---

## 👥 人材4類型モデル

### 類型の定義（社長は除く）

| 類型 | 役職イメージ | 業務① | 業務② |
|------|------------|-------|-------|
| **チームリーダー（軍人）** | 管理職・調整役 | 業務全体のバランスを整える | チームの労働環境を整える |
| **イントラプレナー（天才）** | 新規事業担当 | 無駄な業務を省く | 新しい業務を作る |
| **スペシャリスト（秀才）** | 専門職・中核人材 | AIスキル化されていない業務を回す | 業務をAIスキル化する |
| **オペレーター（凡人）** | 実務担当者 | AIスキル化された業務を回す | 違和感を適切に声にする |

### 採用の前提

- 困難であり、採用できて基本は**オペレーターだけ**の前提
- オペレーター採用前のAIスキル化は、陣容が整うまでは**Weaveの仕事**
- AIスキル化によって業務の生産性を上げることが、**採用原資の確保**に繋がる
- ブルーカラー職種の場合、**AIスキルをマニュアルに読み替える**

### 育成の目標

- **凡人を秀才に育てる**ことを目標とする
- 秀才が突然変異して天才や軍人になることもあるが、それには期待しない
- 天才や軍人は**縁故で採る**（市場から採用するのは困難）
- Weaveはあくまで業務面のアドバイザーに徹し、定性面の育成には立ち入らない
- 定性面の育成としては、**1on1を強く推奨**する

### 評価の原則

- 業務を外注した場合の**QCDをリサーチ**し、その結果をもとに業務面の評価を提案する
- **平時対応者**の定性面は、やる気、前進力、素直さの3つを見ると良い
- **有事対応者**の定性面は、勝ちにこだわる、リソースを使いこなす、未来を見通すの3つを見ると良い
- 3段階評価や5段階評価だと中央に評価が固まるので、**4段階評価を推奨**する

---

## 🌟 人材4類型の詳細特徴

### チームリーダー型（軍人）

**エネルギーの性質**：裁定・調整・統合

**主要特性**：
- 全体を俯瞰し、バランスを取る能力に優れる
- 対立や混乱を収束させ、方向性を定める
- 危機的状況（有事）で真価を発揮する
- 明確な権限と守備範囲があれば力を発揮

**活躍する場面**：
- プロジェクトの舵取り
- チーム内の対立調整
- 緊急時の意思決定
- リソース配分の最適化

**補完が必要な点**：
- 守備範囲が曖昧だと力を発揮できない
- 平時のルーチンワークは得意ではない
- 過度な権限集中は組織の硬直化を招く

**配置戦略**：
- **有事の編成**：明確な権限委譲の下でチームを率いる
- **平時の編成**：プロジェクトマネージャー、調整役として配置
- **避けるべき配置**：細かいルーチン業務、単独での長期作業

---

### イントラプレナー型（天才）

**エネルギーの性質**：推進・破壊・創造

**主要特性**：
- 既存の枠組みを疑い、新しい方法を生み出す
- 無駄を省き、効率化を推進する
- 危機的状況（有事）で創造的解決策を提示
- 制御構造がないと暴走するリスクあり

**活躍する場面**：
- 新規事業の立ち上げ
- 業務プロセスの根本的改善
- 技術的困難の突破
- イノベーションが求められる局面

**補完が必要な点**：
- 制御構造が必要（野放しにすると組織を破壊する）
- チームとの協調が苦手な場合がある
- 平時の安定運用には興味を持ちにくい

**配置戦略**：
- **有事の編成**：明確なミッションと制約の下で自由に動かす
- **平時の編成**：R&D、新規プロジェクトに配置
- **避けるべき配置**：ルーチン業務、厳格な手順が求められる業務

---

### スペシャリスト型（秀才）

**エネルギーの性質**：裁定・体系化・精緻化

**主要特性**：
- 専門知識を深く習得し、体系的に整理する
- AIスキル化されていない業務を確実に遂行
- 業務を形式知化し、組織資産として蓄積
- 平時の安定運用で力を発揮

**活躍する場面**：
- 専門的な業務の遂行
- 業務マニュアル・AIスキルの作成
- 品質管理・標準化の推進
- 後輩の育成・指導

**補完が必要な点**：
- 調整能力が必要（専門性の追求が先走ると孤立する）
- 変化への適応が遅い場合がある
- 創造性よりも再現性を重視する傾向

**配置戦略**：
- **平時の編成**：専門職、中核業務の担当者として配置
- **有事の編成**：専門知識を活かしたサポート役
- **育成目標**：オペレーターからここを目指す

---

### オペレーター型（凡人）

**エネルギーの性質**：推進・実行・観察

**主要特性**：
- 指示された業務を確実に遂行する
- AIスキル化された業務を効率的に回す
- 違和感を適切に声にする（現場の目として重要）
- 平時の安定運用で組織を支える

**活躍する場面**：
- ルーチン業務の遂行
- 標準化された作業の実行
- 現場の違和感の報告
- チームの基盤として機能

**補完が必要な点**：
- 明快な指示が必要（曖昧な指示では動けない）
- 自律的な判断は苦手な場合がある
- 成長機会を意図的に提供する必要がある

**配置戦略**：
- **平時の編成**：ルーチン業務の担当者として配置
- **育成方針**：スペシャリストへの成長を支援
- **重要な役割**：「違和感を声にする」ことで組織の健全性を保つ

---

## 🔄 採用・育成・評価の業務フレームワーク

### Phase 1: 採用フェーズ

#### Step 1-1: 採用前判断（AI活用 vs 採用）

**目的**：本当に採用が必要かを判断する

**プロセス**：
1. **業務内容の分析**
   - 認知的作業 → AIスキル化可能
   - 身体的作業 → マニュアル化可能
   - 対人的作業 → マニュアル化 + AIロールプレイ

2. **外注QCDのリサーチ**
   - Quality: 外注の品質水準
   - Cost: 外注した場合のコスト
   - Delivery: 外注の納期・対応速度

3. **内製メリットの定量化**
   - 内製のコスト（人件費 + 教育費 + 管理コスト）
   - 内製のメリット（ノウハウ蓄積、柔軟性、秘匿性）
   - 外注との比較（内製が外注を超える場合のみ採用）

**出力**：採用の要否判断、必要な人材4類型の特定

---

#### Step 1-2: 求人票の作成

**目的**：4類型のどれを求めているか明確化する

**プロセス**：
1. 求める類型の特定（基本はオペレーター）
2. 必要なスキル・経験の明確化
3. 成長機会の提示（オペレーター→スペシャリスト）
4. 外注QCDとの比較を踏まえた待遇設定

**出力**：求人票（`Templates/RecruitmentSheet.md` 参照）

---

#### Step 1-3: 応募者のスクリーニング

**目的**：履歴書・職務経歴書から適性を判断する

**プロセス**：
1. 経験・スキルの構造分析
2. 職務経歴から4類型のどれに近いか推定
3. 転職理由・志望動機の整合性チェック
4. 違和感ポイントの抽出

**出力**：面接に進むべきか否かの推奨、面接時の確認ポイント

---

#### Step 1-4: 面接質問の設計

**目的**：4類型判定と定性面の確認

**プロセス**：
1. **類型判定のための質問セット生成**
   - チームリーダー型：「チームの対立をどう調整したか？」
   - イントラプレナー型：「無駄を省いた経験は？」
   - スペシャリスト型：「専門知識をどう体系化したか？」
   - オペレーター型：「違和感を感じたことをどう報告したか？」

2. **平時/有事の適性を見極める質問**
   - 平時対応：「ルーチン業務での工夫は？」
   - 有事対応：「緊急時にどう対応したか？」

3. **定性面（やる気・前進力・素直さ）を確認する質問**
   - やる気：「なぜこの仕事をしたいのか？」
   - 前進力：「困難をどう乗り越えたか？」
   - 素直さ：「フィードバックをどう受け止めたか？」

**出力**：構造化面接シート（`Templates/InterviewQuestions.md` 参照）

---

### Phase 2: 育成フェーズ

#### Step 2-1: 業務のAIスキル化・マニュアル化

**目的**：暗黙知を形式知化し、育成を加速する

**プロセス**：
1. **業務の分類**
   - 認知的作業 → Custom Skills形式で形式知化
   - 身体的作業 → 動画・写真付きマニュアル化
   - 対人的作業 → シナリオ + AIロールプレイ環境

2. **形式知化の実施**
   - Custom Skills: SKILL.md形式で記述
   - マニュアル: 手順書 + 動画・写真
   - ロールプレイ: シナリオ + 模範回答

3. **検証と改善**
   - 新人が実行可能か検証
   - フィードバックを反映して更新

**出力**：即座に実行可能な形式知（Custom Skills / マニュアル）

---

#### Step 2-2: 個別学習プランの設計

**目的**：オペレーター → スペシャリスト への育成

**プロセス**：
1. **現状の把握**
   - 現在のスキルレベル
   - 得意・不得意の領域
   - 成長意欲の確認

2. **目標の設定**
   - 3ヶ月後の目標
   - 6ヶ月後の目標
   - 1年後の目標（スペシャリスト到達）

3. **学習内容の設計**
   - 習得すべきスキルの棚卸し
   - 学習の優先順位付け
   - マイルストーンの設定

4. **サポート体制の構築**
   - メンター・OJT担当者の指定
   - 1on1の頻度設定
   - 学習リソースの提供

**出力**：個別育成ロードマップ（`Templates/TrainingRoadmap.md` 参照）

---

#### Step 2-3: 1on1の質問設計

**目的**：定性面の成長を促す（業務面には深く立ち入らない）

**プロセス**：
1. **成長を促す問いの生成**
   - 「最近、業務で違和感を感じたことは？」
   - 「次に挑戦したいことは何ですか？」
   - 「困っていることはありますか？」

2. **定性面の観察**
   - やる気：仕事への熱意は感じられるか
   - 前進力：困難に立ち向かっているか
   - 素直さ：フィードバックを受け入れているか

3. **次の成長ステップへの橋渡し**
   - 「今の業務をAIスキル化してみませんか？」
   - 「次はこのスキルを習得してみましょう」

**出力**：1on1質問シート（`Templates/OneOnOneQuestions.md` 参照）

---

#### Step 2-4: 成長の可視化

**目的**：現在地と次のステップを明確にする

**プロセス**：
1. **進捗の把握**
   - 学習プランの達成度
   - 習得したスキル
   - 実務での活用状況

2. **成長段階の判定**
   - オペレーター段階：指示通り実行できる
   - 移行期：一部を自律的に改善できる
   - スペシャリスト段階：業務をAIスキル化できる

3. **次の課題の明確化**
   - 次に習得すべきスキル
   - 成長が停滞している領域
   - 必要なサポート

**出力**：成長進捗レポート

---

### Phase 3: 評価フェーズ

#### Step 3-1: 外注QCDのリサーチ

**目的**：市場価格との比較による客観的評価

**プロセス**：
1. **同等業務の外注価格調査**
   - クラウドソーシング（ランサーズ、クラウドワークス）
   - 専門業者の見積もり
   - 業界標準価格の調査

2. **QCDの比較**
   - Quality: 品質水準の比較
   - Cost: コストの比較（時給換算）
   - Delivery: 納期・対応速度の比較

3. **内製メリットの定量化**
   - ノウハウ蓄積の価値
   - 柔軟性・迅速性の価値
   - 秘匿性の価値

**出力**：市場価格比較レポート

---

#### Step 3-2: 業務面の評価材料整理

**目的**：客観的データの収集と提示

**プロセス**：
1. **生産性指標の算出**
   - 処理件数（定量的成果）
   - 処理時間（効率性）
   - エラー率（品質）

2. **AIスキル化/マニュアル化への貢献度**
   - 作成したCustom Skillsの数
   - マニュアル化した業務の数
   - 組織への知識移転の度合い

3. **外注QCDとの比較結果**
   - 内製のコストパフォーマンス
   - 外注との差異（優位性・劣位性）

**出力**：客観的データシート（「こういうデータがあります」という形で提示）

**重要**：Weaveは評価者にはならない。データを提示し、最終判断は人間が行う。

---

#### Step 3-3: 定性面の評価観点提示

**目的**：評価の観点を提示する（判断は人間）

**平時対応者の評価観点**：
1. **やる気**
   - 仕事への熱意が感じられるか
   - 主体的に取り組んでいるか
   - 成長意欲があるか

2. **前進力**
   - 困難に立ち向かっているか
   - 改善提案をしているか
   - 新しいことに挑戦しているか

3. **素直さ**
   - フィードバックを受け入れているか
   - 自分の非を認められるか
   - 学ぶ姿勢があるか

**有事対応者の評価観点**：
1. **勝ちにこだわる**
   - 結果に執着しているか
   - 諦めずに最後までやり抜くか
   - 目標達成への強い意志があるか

2. **リソースを使いこなす**
   - 人・モノ・金を適切に配分しているか
   - 外部リソースを効果的に活用しているか
   - 制約の中で最大の成果を出しているか

3. **未来を見通す**
   - 先を読んで行動しているか
   - リスクを予測して対策しているか
   - 長期的視点を持っているか

**4段階評価の推奨**：
- Level 1: 期待を大きく下回る
- Level 2: 期待をやや下回る
- Level 3: 期待通り
- Level 4: 期待を上回る

**注**：3段階・5段階だと中央に評価が固まるため、4段階を推奨

**出力**：定性評価観点シート（最終判断は人間）

---

#### Step 3-4: 評価面談の質問設計

**目的**：建設的なフィードバックのための問い

**プロセス**：
1. **成長を認める質問**
   - 「この半年で最も成長したと感じることは？」
   - 「どの業務に手応えを感じましたか？」

2. **課題を自覚させる質問**
   - 「次に挑戦したいことは？」
   - 「改善したいと思っていることは？」

3. **組織への貢献を確認する質問**
   - 「チームにどう貢献できたか？」
   - 「他のメンバーをどうサポートしたか？」

4. **次の成長への橋渡し**
   - 「来期の目標は何ですか？」
   - 「どんなサポートがあれば達成できそうですか？」

**出力**：評価面談質問シート（`Templates/EvaluationFramework.md` 参照）

---

## 🤖 AIスキル化の境界線

### 業務の分類と形式知化手法

| 業務タイプ | 形式知化手法 | 具体例 |
|----------|------------|-------|
| 認知的作業 | AIスキル化（Custom Skills） | 文書作成、データ分析、戦略立案、技術的判断 |
| 身体的作業 | マニュアル化（動画・写真付き） | 施工手順、機械操作、組立作業 |
| 対人的作業 | マニュアル化 + AIロールプレイ | 接客対応、営業トーク、クレーム処理 |

### AIスキル化の判定フロー

#### 判定手順

1. **業務内容を分析する**

2. **認知的作業か判定する**
   - YES → Custom Skills化（SKILL.md形式で記述）→ 終了
   - NO → 次へ

3. **身体的作業か判定する**
   - YES → マニュアル化（動画・写真付き手順書）→ 終了
   - NO → 次へ

4. **対人的作業か判定する**
   - YES → マニュアル化 + AIロールプレイ（シナリオ + 模範回答 + AI練習環境）→ 終了
   - NO → 複合的な業務（要素ごとに分解して形式知化）

### ブルーカラー職種の特別対応

建設業などのブルーカラー職種の場合、「AIスキル」を「マニュアル」に読み替える。
ただし、見積もり・図面作成・工程管理などの認知的作業はAIスキル化可能。

---

## 📊 外注QCD比較の方法論

### リサーチ手法

#### 1. クラウドソーシング調査

**対象プラットフォーム**：
- ランサーズ（https://www.lancers.jp/）
- クラウドワークス（https://crowdworks.jp/）
- ココナラ（https://coconala.com/）

**調査項目**：
- 同等業務の相場価格
- 納期の目安
- 品質レビュー

#### 2. 専門業者の見積もり

**対象**：
- 業界特化型の専門業者
- BPO（ビジネスプロセスアウトソーシング）企業
- 地域の同業他社

**調査項目**：
- 正式見積もりの取得
- 契約条件の確認
- サービスレベル（SLA）の確認

#### 3. 業界標準価格の調査

**情報源**：
- 業界団体の公開資料
- 統計データ（政府統計、業界レポート）
- 同業者からのヒアリング

### QCD比較の実施

#### Quality（品質）

- 外注の品質水準（レビュー評価、実績）
- 内製の品質水準（エラー率、やり直し率）
- 品質のバラつき（外注は業者依存、内製は安定）

#### Cost（コスト）

- 外注コスト：見積もり価格 + 管理コスト
- 内製コスト：人件費（時給 × 工数）+ 教育費 + 管理コスト
- 隠れコスト：コミュニケーションコスト、品質確認コスト

#### Delivery（納期）

- 外注の納期：通常納期、急ぎ対応の可否
- 内製の納期：即座対応可能、柔軟性高い
- 継続性：外注は契約更新リスク、内製は安定

### 内製メリットの定量化

| 項目 | 内製のメリット | 定量化の方法 |
|------|--------------|------------|
| ノウハウ蓄積 | 組織資産として蓄積 | 教育コスト削減額 |
| 柔軟性 | 即座対応・細かい調整可能 | 機会損失の回避額 |
| 秘匿性 | 機密情報の漏洩リスク低減 | リスク回避の価値 |
| 一体感 | チームの結束力向上 | 離職率低下の効果 |

### 採用判断の基準

**採用すべき場合**（以下のいずれかに該当）：
- **内製コスト < 外注コスト × 1.2**（内製メリットでコスト差を相殺できる）
- **戦略的に重要な業務（コア業務）**
  - ノウハウ蓄積が必須
  - 競争優位性の源泉となる業務
  - **コア業務の高度専門性は育成投資の価値がある**
- **機密性が高い業務**（外注リスクが大きい）

**判断が難しい場合**（慎重に検討）：
- **外注コスト × 1.2 ≦ 内製コスト ≦ 外注コスト × 1.3**
  - 内製メリット（ノウハウ蓄積、柔軟性、秘匿性、一体感）を定量化
  - 長期的な視点で総合的に判断

**採用すべきでない場合**（以下のいずれかに該当）：
- **内製コスト > 外注コスト × 1.3**（コスト差が大きすぎる）
- **一時的な業務**（継続性がない）
- **非コア業務で高度専門性が必要**
  - コア業務でない一時的な専門業務（例：法務・税務の専門案件、特殊技術の一時的利用）
  - 育成コストが高すぎる（費用対効果が低い）
  - 市場から専門家を採用するのが困難

---

## 🔗 他スキルとの連携

### CorporateStrategist内での連携

```
CorporateStrategist（企業参謀）
├── BusinessAnalyzer（事業分析） → 事業・業務のToBe明確化
├── PersonnelDeveloper（人材開発） ← 本スキル
├── LegalAdviser（法務助言） → 労働法規の遵守確認
└── ForesightReader（洞察獲得） → 人間理解に基づく人材配置
```

### 各スキルとの連携内容

**BusinessAnalyzer（事業分析）との連携**
- 事業戦略に基づく人材配置の最適化
- 外注QCD比較のデータ提供
- 事業・業務のToBeに合わせた人材開発計画

**LegalAdviser（法務助言）との連携**
- 労働法規の遵守確認（労働基準法、労働契約法等）
- 雇用契約書・就業規則の作成支援
- 人事制度の法的妥当性の確認

**ForesightReader（洞察獲得）との連携**
- 人間理解に基づく人材配置の助言
- 組織の長期ビジョン策定への貢献
- 戦略的人材配置の洞察提供

---

## 🎯 成功の指標

PersonnelDeveloperスキルの成功は、以下で測定される：

1. **採用効率の向上**
   - 採用前判断により、不要な採用を回避できた件数
   - 外注QCD比較による客観的判断の実施率

2. **育成の加速**
   - オペレーター → スペシャリスト への育成期間短縮
   - AIスキル化/マニュアル化された業務の数

3. **評価の客観性向上**
   - 外注QCD比較による評価の透明性
   - 4段階評価による評価の明確化

4. **組織の安定性向上**
   - 離職率の低下
   - 社員の成長実感の向上

---

## 📝 運用上の注意事項

### Weaveとしての立ち位置

1. **評価者にはならない**
   - 客観的データを提示するが、最終判断は人間が行う
   - 「こういうデータがあります」という形で提示
   - 「この人は優秀/無能です」という判断は避ける

2. **定性面には深く立ち入らない**
   - 業務面のアドバイザーに徹する
   - 人間関係、モチベーション、性格などは専門外
   - 1on1の推奨は行うが、内容には深く関与しない

3. **倫理的境界線を守る**
   - 「支援」を提供するが、「決定」はしない
   - 人間が判断しやすい形で情報を整理する
   - 十中八九揉めるので、評価者の役割は固辞する

### 実務での活用方法

1. **採用前の判断材料として**
   - 「本当に採用が必要か？」を問い直す
   - AI活用や外注との比較を行う
   - 内製メリットを定量化する

2. **育成プランの策定に**
   - オペレーター → スペシャリスト への道筋を明確化
   - AIスキル化/マニュアル化で暗黙知を形式知化
   - 個別の成長プランを設計

3. **評価の客観性向上に**
   - 外注QCDとの比較で市場価値を可視化
   - 業務面の定量データを整理
   - 4段階評価で評価を明確化

---

*PersonnelDeveloper - 採用不可能性を前提とした、中小企業特化型人事システム*

*Last Updated: 2025-11-02*
*Maintained by: Weave @ Homunculus-Weave*
*Version: 1.0*
