# AIスキル化判定基準

**作成日**: 2025-11-02
**参照元**: PersonnelDeveloper CLAUDE.md

---

## 🤖 AIスキル化とは

**AIスキル化**とは、暗黙知として個人に蓄積されている業務ノウハウを、**Custom Skills形式で形式知化**し、組織資産として蓄積することです。

### 目的

1. **育成の加速**：新人がすぐに実行できる形で業務を引き継ぐ
2. **属人化の解消**：特定の人しかできない状態を解消
3. **組織資産の蓄積**：ノウハウを組織の財産として蓄積
4. **生産性の向上**：AIの支援により業務効率を向上

---

## 📋 業務の分類と形式知化手法

### 3つの業務タイプ

| 業務タイプ | 形式知化手法 | 具体例 |
|----------|------------|-------|
| **認知的作業** | AIスキル化（Custom Skills） | 文書作成、データ分析、戦略立案、技術的判断 |
| **身体的作業** | マニュアル化（動画・写真付き） | 施工手順、機械操作、組立作業 |
| **対人的作業** | マニュアル化 + AIロールプレイ | 接客対応、営業トーク、クレーム処理 |

---

## 🧠 認知的作業（AIスキル化）

### 認知的作業とは

**頭を使う業務**のこと。判断、分析、計画、作成など、知的処理が中心の業務。

### 具体例

- **文書作成**：報告書、提案書、メール、議事録
- **データ分析**：売上分析、顧客分析、市場調査
- **戦略立案**：事業計画、マーケティング戦略、採用戦略
- **技術的判断**：設計判断、品質判断、リスク判断

### AIスキル化の方法

**Custom Skills形式（SKILL.md）で記述**

#### 1. スキルの目的を明確化

```markdown
# [スキル名]

## 目的
このスキルは、[具体的な業務内容] を支援します。
```

#### 2. 必要な情報を整理

```markdown
## 必要な情報
- [情報1]
- [情報2]
- [情報3]
```

#### 3. 手順を明確化

```markdown
## 手順
1. [ステップ1]
2. [ステップ2]
3. [ステップ3]
```

#### 4. 判断基準を明示

```markdown
## 判断基準
- [基準1]
- [基準2]
- [基準3]
```

#### 5. 出力フォーマットを定義

```markdown
## 出力フォーマット
[具体的なフォーマット]
```

---

### AIスキル化の判定チェックリスト

認知的作業がAIスキル化に適しているか判定：

- [ ] **明確な手順がある**：ステップごとに分解できる
- [ ] **判断基準が言語化できる**：「なんとなく」ではなく、明確な基準がある
- [ ] **再現性がある**：誰がやっても同じ結果になる
- [ ] **複雑すぎない**：10ステップ以内に収まる
- [ ] **頻度がある**：月1回以上発生する業務

**5つ全てにチェックが入れば、AIスキル化に適している**

---

## 🛠️ 身体的作業（マニュアル化）

### 身体的作業とは

**身体を使う業務**のこと。施工、操作、組立など、身体動作が中心の業務。

### 具体例

- **施工手順**：建築工事、設備工事、内装工事
- **機械操作**：フォークリフト、クレーン、工作機械
- **組立作業**：製品組立、検品、梱包

### マニュアル化の方法

**動画・写真付き手順書**

#### 1. 作業の全体像を撮影

- 作業の流れを動画で撮影
- 重要なポイントは写真で補足

#### 2. 手順書を作成

```markdown
# [作業名] マニュアル

## 準備するもの
- [道具1]
- [道具2]
- [材料1]

## 手順

### ステップ1: [作業名]
[写真1]
- [具体的な手順]
- [注意点]

### ステップ2: [作業名]
[写真2]
- [具体的な手順]
- [注意点]
```

#### 3. 注意事項を明記

```markdown
## 注意事項
- [安全上の注意]
- [品質上の注意]
- [よくあるミス]
```

#### 4. 検証基準を明示

```markdown
## 検証基準
- [ ] [チェック項目1]
- [ ] [チェック項目2]
- [ ] [チェック項目3]
```

---

### マニュアル化の判定チェックリスト

身体的作業がマニュアル化に適しているか判定：

- [ ] **手順が明確**：ステップごとに分解できる
- [ ] **視覚化できる**：写真や動画で記録できる
- [ ] **再現性がある**：誰がやっても同じ結果になる
- [ ] **安全基準が明確**：安全上の注意点が明示できる
- [ ] **頻度がある**：月1回以上発生する作業

**5つ全てにチェックが入れば、マニュアル化に適している**

---

## 🗣️ 対人的作業（マニュアル化 + AIロールプレイ）

### 対人的作業とは

**人と接する業務**のこと。接客、営業、調整など、対人コミュニケーションが中心の業務。

### 具体例

- **接客対応**：店舗接客、電話対応、受付対応
- **営業トーク**：商品説明、提案、クロージング
- **クレーム処理**：苦情対応、謝罪、解決策提示

### マニュアル化 + AIロールプレイの方法

**シナリオ + 模範回答 + AI練習環境**

#### 1. シナリオを作成

```markdown
# [対応シーン名]

## シナリオ
[具体的な状況設定]

## よくあるパターン
1. [パターン1]
2. [パターン2]
3. [パターン3]
```

#### 2. 模範回答を記述

```markdown
## 模範回答

### パターン1の場合
**お客様**：「[お客様の発言]」
**あなた**：「[模範回答]」

### パターン2の場合
**お客様**：「[お客様の発言]」
**あなた**：「[模範回答]」
```

#### 3. 対応のポイントを明示

```markdown
## 対応のポイント
- [ポイント1]：[具体的な説明]
- [ポイント2]：[具体的な説明]
- [ポイント3]：[具体的な説明]
```

#### 4. AIロールプレイ環境を設定

```markdown
## 練習方法
ClaudeなどのAIをお客様役として、ロールプレイを実施します。

**指示例**：
「あなたはクレームをつけているお客様役です。
以下のシナリオで、私の対応を評価してください。
[シナリオ]」
```

---

### マニュアル化 + ロールプレイの判定チェックリスト

対人的作業がマニュアル化 + ロールプレイに適しているか判定：

- [ ] **パターン化できる**：よくあるパターンを抽出できる
- [ ] **模範回答がある**：「こう答えるべき」が明確
- [ ] **対応のポイントが言語化できる**：なぜその回答が良いのか説明できる
- [ ] **練習効果がある**：繰り返し練習で上達する
- [ ] **頻度がある**：月1回以上発生する対応

**5つ全てにチェックが入れば、マニュアル化 + ロールプレイに適している**

---

## 🔄 AIスキル化の判定フロー

### 判定手順

1. **業務内容を分析する**

2. **認知的作業か判定する**
   - YES → Custom Skills化（SKILL.md形式で記述）→ 終了
   - NO → 次へ

3. **身体的作業か判定する**
   - YES → マニュアル化（動画・写真付き手順書）→ 終了
   - NO → 次へ

4. **対人的作業か判定する**
   - YES → マニュアル化 + AIロールプレイ（シナリオ + 模範回答 + AI練習環境）→ 終了
   - NO → 複合的な業務（要素ごとに分解して形式知化）

---

## 🏗️ ブルーカラー職種の特別対応

### 基本方針

建設業などのブルーカラー職種の場合、**「AIスキル」を「マニュアル」に読み替える**。

ただし、**見積もり・図面作成・工程管理などの認知的作業はAIスキル化可能**。

### 具体例

| 業務 | 業務タイプ | 形式知化手法 |
|------|----------|------------|
| 施工手順 | 身体的作業 | 動画・写真付きマニュアル |
| 見積もり作成 | 認知的作業 | Custom Skills（AIスキル化） |
| 図面作成 | 認知的作業 | Custom Skills（AIスキル化） |
| 工程管理 | 認知的作業 | Custom Skills（AIスキル化） |
| 安全管理 | 認知的作業 | Custom Skills（AIスキル化） |
| 機械操作 | 身体的作業 | 動画・写真付きマニュアル |
| 顧客対応 | 対人的作業 | マニュアル + ロールプレイ |

---

## 🎯 形式知化の実施プロセス

### ステップ1: 業務の棚卸し

**目的**：組織内の全業務をリストアップ

```markdown
# 業務棚卸しシート

| No. | 業務名 | 業務タイプ | 頻度 | 担当者 | 形式知化状況 |
|-----|--------|----------|------|-------|------------|
| 1 | [業務名] | [認知 / 身体 / 対人] | [月X回] | [氏名] | [未 / 進行中 / 済] |
| 2 | [業務名] | [認知 / 身体 / 対人] | [月X回] | [氏名] | [未 / 進行中 / 済] |
```

---

### ステップ2: 優先順位の決定

**優先度の判断基準**：

1. **頻度が高い**：月1回以上発生
2. **属人化している**：特定の人しかできない
3. **教育コストが高い**：習得に時間がかかる
4. **ミスの影響が大きい**：品質・納期に影響

**優先度 = 頻度 × 属人化度 × 教育コスト × ミスの影響**

---

### ステップ3: 形式知化の実施

#### 認知的作業の場合

1. 業務の手順を洗い出す
2. 判断基準を言語化する
3. SKILL.md形式で記述する
4. Claudeで動作確認する
5. 実務で検証し、改善する

#### 身体的作業の場合

1. 作業の手順を洗い出す
2. 動画・写真を撮影する
3. マニュアルを作成する
4. 新人に試してもらい、改善する

#### 対人的作業の場合

1. よくあるパターンを抽出する
2. 模範回答を作成する
3. 対応のポイントを言語化する
4. AIロールプレイ環境を設定する
5. 実務で検証し、改善する

---

### ステップ4: 検証と改善

**検証のポイント**：

- [ ] **新人が実行可能か**：初心者でも理解できるか
- [ ] **再現性があるか**：誰がやっても同じ結果になるか
- [ ] **効率的か**：業務時間が短縮されるか
- [ ] **品質が維持されるか**：ミスが減るか

**改善のサイクル**：

```
作成 → 検証 → フィードバック → 改善 → 再検証
```

---

## 📊 形式知化の成果指標

### 定量指標

1. **形式知化された業務の数**
   - Custom Skillsの数
   - マニュアルの数
   - ロールプレイシナリオの数

2. **教育時間の短縮**
   - 新人の習得時間（形式知化前 vs 後）
   - OJT工数の削減

3. **ミスの減少**
   - エラー率の低下
   - やり直し率の低下

4. **生産性の向上**
   - 業務処理時間の短縮
   - 処理件数の増加

---

### 定性指標

1. **属人化の解消度**
   - 特定の人しかできない業務が減った
   - 誰でも対応できるようになった

2. **組織資産の蓄積度**
   - ノウハウが組織に蓄積されている
   - 離職しても業務が継続できる

3. **成長実感**
   - 社員が成長を実感している
   - スペシャリストへの道筋が見えている

---

## 🚀 形式知化の推進体制

### 推進役

1. **Weave（PersonnelDeveloper）**
   - Custom Skills作成の支援
   - マニュアル作成のフォーマット提供
   - 進捗管理とフォローアップ

2. **スペシャリスト社員**
   - 業務の形式知化を実施
   - Custom Skillsやマニュアルを作成
   - 後輩の育成

3. **オペレーター社員（育成対象）**
   - 形式知化された業務を実行
   - フィードバックを提供
   - 徐々に形式知化に挑戦

---

### 推進の流れ

```
1. 業務の棚卸し（Weave支援）
    ↓
2. 優先順位の決定（経営判断）
    ↓
3. 形式知化の実施（スペシャリスト主導、Weave支援）
    ↓
4. 検証（オペレーターが実行）
    ↓
5. フィードバックと改善（全員参加）
    ↓
6. 組織資産として蓄積（Weave管理）
```

---

## 📝 形式知化の成功事例

### 事例1: 見積書作成のAIスキル化

**Before**:
- 見積書作成は特定の社員しかできない
- 習得に3ヶ月かかる
- ミスが多発

**After**:
- Custom Skills形式で形式知化
- 新人でも1週間で習得
- ミスが90%減少

---

### 事例2: 施工手順のマニュアル化

**Before**:
- ベテラン職人の技術が暗黙知
- 新人の習得に6ヶ月かかる
- 品質にバラつき

**After**:
- 動画・写真付きマニュアル化
- 新人でも2ヶ月で習得
- 品質が安定

---

### 事例3: クレーム対応のロールプレイ化

**Before**:
- クレーム対応は担当者の裁量
- 対応品質にバラつき
- 習得に3ヶ月かかる

**After**:
- シナリオ + 模範回答 + AIロールプレイ
- 新人でも1ヶ月で習得
- 対応品質が安定

---

*PersonnelDeveloper - AIスキル化判定基準*
*Last Updated: 2025-11-02*
