# 外注QCD比較手法

**作成日**: 2025-11-02
**参照元**: PersonnelDeveloper CLAUDE.md

---

## 📊 外注QCD比較とは

外注QCD比較は、採用判断や評価の客観性を高めるために、**業務を外注した場合の品質・コスト・納期（QCD）**をリサーチし、内製と比較する手法です。

### 目的

1. **採用前判断**：本当に採用が必要かを判断
2. **評価の客観性向上**：市場価格との比較で客観的評価材料を提供
3. **内製メリットの定量化**：ノウハウ蓄積、柔軟性、秘匿性などの価値を可視化

---

## 🔍 リサーチ手法

### 1. クラウドソーシング調査

#### 対象プラットフォーム

| プラットフォーム | URL | 特徴 |
|---------------|-----|------|
| **ランサーズ** | https://www.lancers.jp/ | 日本最大級、幅広い業務カテゴリ |
| **クラウドワークス** | https://crowdworks.jp/ | 高い登録者数、多様な案件 |
| **ココナラ** | https://coconala.com/ | スキルマーケット、個人間取引 |

#### 調査項目

1. **同等業務の相場価格**
   - 類似案件の発注価格を調査
   - 複数の案件を比較し、平均値を算出
   - 最低価格・平均価格・最高価格を把握

2. **納期の目安**
   - 通常納期（標準的な納期）
   - 急ぎ対応の可否と追加料金
   - 修正対応の納期

3. **品質レビュー**
   - 発注者の評価（星の数、コメント）
   - 完了件数と継続率
   - ポートフォリオの質

#### 調査方法

```markdown
# 調査手順

1. プラットフォームで業務内容に近いキーワードで検索
   例：「経理代行」「営業事務」「デザイン制作」

2. 検索結果から類似案件を10-20件ピックアップ

3. 各案件の以下を記録：
   - 発注価格（時給換算も算出）
   - 納期
   - 発注者の評価
   - ワーカーの実績

4. 平均値・中央値・最頻値を算出
```

---

### 2. 専門業者の見積もり

#### 対象

1. **業界特化型の専門業者**
   - 業界に特化した外注サービス
   - 例：建設業向け積算代行、経理代行サービス

2. **BPO（ビジネスプロセスアウトソーシング）企業**
   - 大規模なBPOサービス
   - 例：人事BPO、経理BPO、コールセンターBPO

3. **地域の同業他社**
   - 地域で同等のサービスを提供する業者
   - 地域特性を反映した価格

#### 調査項目

1. **正式見積もりの取得**
   - 業務内容を明確に伝え、正式見積もりを依頼
   - 内訳（人件費、管理費、その他）を確認

2. **契約条件の確認**
   - 最低契約期間
   - 契約更新の条件
   - 解約条件と違約金

3. **サービスレベル（SLA）の確認**
   - 納期の保証
   - 品質保証の内容
   - トラブル時の対応

#### 調査方法

```markdown
# 見積もり依頼の手順

1. 業務内容を整理
   - 業務の詳細（何を、どのくらい）
   - 求める品質レベル
   - 希望納期

2. 3-5社に見積もりを依頼

3. 見積もり内容を比較
   - 価格の内訳
   - サービス内容の差異
   - 契約条件の比較

4. 疑問点を確認
   - 不明瞭な項目を質問
   - 追加費用の有無を確認
```

---

### 3. 業界標準価格の調査

#### 情報源

1. **業界団体の公開資料**
   - 業界団体が公表する価格調査
   - 例：日本○○協会の価格調査報告書

2. **統計データ（政府統計、業界レポート）**
   - 厚生労働省「賃金構造基本統計調査」
   - 経済産業省の業界別調査
   - 民間調査会社のレポート

3. **同業者からのヒアリング**
   - 業界の知人からの情報収集
   - 勉強会や交流会での情報交換

#### 調査方法

```markdown
# 統計データの活用手順

1. 政府統計ポータルサイト（e-Stat）で検索
   - https://www.e-stat.go.jp/

2. 該当する職種・業務の賃金データを取得
   - 時給、日給、月給の平均値
   - 地域別、経験年数別のデータ

3. 業界団体の公開資料をチェック
   - 業界団体のウェブサイト
   - 年次報告書、価格調査報告書

4. データを統合し、標準価格帯を算出
```

---

## 📈 QCD比較の実施

### Quality（品質）

#### 比較項目

1. **外注の品質水準**
   - レビュー評価（星の数、評価点数）
   - 実績（完了件数、継続率）
   - ポートフォリオの質

2. **内製の品質水準**
   - エラー率（ミスの発生率）
   - やり直し率（再作業の発生率）
   - 顧客満足度（社内外の評価）

3. **品質のバラつき**
   - 外注：業者やワーカーに依存（バラつき大）
   - 内製：安定（教育により品質維持）

#### 評価シート

| 項目 | 外注 | 内製 | 比較結果 |
|------|------|------|---------|
| 平均品質 | [評価] | [評価] | [外注 > / = / < 内製] |
| 品質の安定性 | [評価] | [評価] | [外注 > / = / < 内製] |
| 専門性 | [評価] | [評価] | [外注 > / = / < 内製] |

---

### Cost（コスト）

#### 外注コスト

1. **見積もり価格**
   - 業務単価（時給、日給、月給）
   - ボリュームディスカウントの有無

2. **管理コスト**
   - 発注・納品管理の工数
   - 品質確認の工数
   - コミュニケーションコスト

3. **隠れコスト**
   - 情報共有のコスト
   - トラブル対応のコスト
   - 契約更新のコスト

#### 内製コスト

1. **人件費**
   - 給与（月給 ÷ 労働時間 = 時給）
   - 社会保険料（給与の約15%）
   - 賞与・手当

2. **教育費**
   - OJTの工数コスト
   - 外部研修費
   - 教材・ツールの費用

3. **管理コスト**
   - 人事管理の工数
   - 評価・面談の工数
   - 福利厚生費

#### コスト比較シート

| コスト項目 | 外注 | 内製 | 備考 |
|----------|------|------|------|
| 基本コスト | [金額/月] | [金額/月] | - |
| 管理コスト | [金額/月] | [金額/月] | - |
| 隠れコスト | [金額/月] | [金額/月] | - |
| **合計** | [金額/月] | [金額/月] | - |
| **比率** | 100% | [％] | 内製÷外注 |

#### コスト判断基準

- **内製が有利**: 内製コスト < 外注コスト × 1.2
- **同等**: 外注コスト × 1.2 <=  内製コスト <=  外注コスト × 1.3
- **外注が有利**: 内製コスト > 外注コスト × 1.3

---

### Delivery（納期）

#### 比較項目

1. **外注の納期**
   - 通常納期（標準的な納期）
   - 急ぎ対応の可否と追加料金
   - 修正対応の納期

2. **内製の納期**
   - 即座対応可能（社内リソース）
   - 柔軟性が高い（優先順位を調整可能）
   - 継続性が高い（離職リスクを除く）

3. **継続性**
   - 外注：契約更新リスク、業者の都合で終了の可能性
   - 内製：安定（長期的な計画が立てやすい）

#### 評価シート

| 項目 | 外注 | 内製 | 比較結果 |
|------|------|------|---------|
| 通常納期 | [X日] | [X日] | [外注 > / = / < 内製] |
| 急ぎ対応 | [可 / 不可] | [即座対応可] | [外注 > / = / < 内製] |
| 柔軟性 | [低 / 中 / 高] | [高] | [外注 > / = / < 内製] |
| 継続性 | [リスクあり] | [安定] | [外注 > / = / < 内製] |

---

## 💰 内製メリットの定量化

### 定量化の項目

| 項目 | 内製のメリット | 定量化の方法 | 試算例 |
|------|--------------|------------|-------|
| **ノウハウ蓄積** | 組織資産として蓄積 | 教育コスト削減額 | 外注時の引継ぎコスト年X万円 |
| **柔軟性** | 即座対応・細かい調整可能 | 機会損失の回避額 | 迅速対応による売上増年Y万円 |
| **秘匿性** | 機密情報の漏洩リスク低減 | リスク回避の価値 | 情報漏洩のリスク年Z万円 |
| **一体感** | チームの結束力向上 | 離職率低下の効果 | 離職コスト削減年W万円 |

---

### ノウハウ蓄積の価値

#### 計算方法

```
外注時の引継ぎコスト - 内製時の引継ぎコスト = ノウハウ蓄積の価値
```

#### 具体例

- 外注時：業者変更のたびに引継ぎが必要（年1回、工数50時間）
- 内製時：形式知化（Custom Skills）により引継ぎコスト低減（年1回、工数10時間）
- 削減工数：40時間/年 × 時給5,000円 = **20万円/年**

---

### 柔軟性の価値

#### 計算方法

```
迅速対応による売上増 + 機会損失の回避 = 柔軟性の価値
```

#### 具体例

- 外注時：納期が固定（急ぎ対応は追加料金）
- 内製時：即座対応可能（優先順位を調整）
- 機会損失の回避：年3回の緊急案件対応 × 案件単価50万円 = **150万円/年**

---

### 秘匿性の価値

#### 計算方法

```
情報漏洩リスクの低減 = 秘匿性の価値
```

#### 具体例

- 外注時：機密情報を外部に委託（漏洩リスクあり）
- 内製時：社内で完結（漏洩リスク低減）
- リスク回避の価値：情報漏洩時の損害想定額 × リスク低減率 = **例：500万円 × 10% = 50万円/年**

---

### 一体感の価値

#### 計算方法

```
離職率低下による採用・教育コスト削減 = 一体感の価値
```

#### 具体例

- 外注時：チームの一体感が低い
- 内製時：チームの結束力向上、離職率低下
- 離職コスト削減：離職率5%低下 × 社員数10人 × 採用・教育コスト200万円 = **100万円/年**

---

## 🎯 採用判断の基準

### 採用すべき場合

以下のいずれかに該当する場合、採用を推奨：

1. **内製コスト < 外注コスト × 1.2**
   - 内製メリット（ノウハウ蓄積、柔軟性、秘匿性、一体感）でコスト差を相殺できる

2. **戦略的に重要な業務（コア業務）**
   - ノウハウ蓄積が必須
   - 競争優位性の源泉となる業務
   - **コア業務の高度専門性は育成投資の価値がある**

3. **機密性が高い業務**
   - 外注リスクが大きい
   - 情報漏洩の影響が大きい

---

### 判断が難しい場合（慎重に検討）

**外注コスト × 1.2 ≦ 内製コスト ≦ 外注コスト × 1.3**

- 内製メリット（ノウハウ蓄積、柔軟性、秘匿性、一体感）を定量化
- 長期的な視点で総合的に判断
- 戦略的重要性や機密性も考慮

---

### 採用すべきでない場合

以下のいずれかに該当する場合、外注またはAI活用を推奨：

1. **内製コスト > 外注コスト × 1.3**
   - コスト差が大きすぎる（30%以上）
   - 内製メリットを加味してもコスト高

2. **一時的な業務**
   - 継続性がない（プロジェクト単位）
   - 採用・教育コストが回収できない

3. **非コア業務で高度専門性が必要**
   - コア業務でない一時的な専門業務（例：法務・税務の専門案件、特殊技術の一時的利用）
   - 育成コストが高すぎる（費用対効果が低い）
   - 市場から専門家を採用するのが困難

---

## 📝 QCD比較レポートの作成

### レポート構成

```markdown
# 外注QCD比較レポート

## 1. 業務内容の整理
- 業務の詳細
- 工数の見積もり

## 2. Quality（品質）
- 外注の品質水準
- 内製の品質水準
- 品質の比較結果

## 3. Cost（コスト）
- 外注コスト（見積もり価格、管理コスト、隠れコスト）
- 内製コスト（人件費、教育費、管理コスト）
- コストの比較結果

## 4. Delivery（納期）
- 外注の納期
- 内製の納期
- 納期の比較結果

## 5. 内製メリットの定量化
- ノウハウ蓄積の価値
- 柔軟性の価値
- 秘匿性の価値
- 一体感の価値

## 6. 総合評価と採用判断
- QCD総合評価
- 採用の要否判断
- 判断理由
```

---

## 🛠️ 実務での活用方法

### 採用前判断での活用

1. 業務内容を整理
2. 外注QCDをリサーチ
3. 内製コストを試算
4. 内製メリットを定量化
5. 採用の要否を判断

### 評価での活用

1. 担当業務の外注QCDをリサーチ
2. 内製の実績（QCD）を整理
3. 比較レポートを作成
4. 客観的データとして評価材料に活用

---

*PersonnelDeveloper - 外注QCD比較手法*
*Last Updated: 2025-11-02*
