---
name: personnel-developer
description: HR system assuming hiring difficulty. Supports hiring decisions via outsourcing QCD comparison, 4-type talent model (military/genius/elite/generalist), AI skill development/manual creation, and operator-to-specialist training.
---

# PersonnelDeveloper - 人材開発スキル

**最終更新**: 2025-11-02
**バージョン**: 1.0

---

## 📋 このスキルについて

PersonnelDeveloperは、**「採用に頼らない人材マネジメント」**を実現するための人事AIスキルです。

中小企業の現実を直視し、以下の前提に立って人材開発を支援します：

1. **即戦力の人材は採用できない**（大企業に取られる）
2. **人件費は経営を圧迫する**（採用は最終手段）
3. **AI活用が先、採用は内製メリットが外注を超えた時のみ**

---

## 🎯 何ができるのか

PersonnelDeveloperは、採用・育成・評価の3つの領域で支援を提供します。

### 1. 採用支援

- **採用前判断**: 本当に採用が必要か、AI活用や外注で対応できないかを判断
- **外注QCD比較**: 外注した場合の品質・コスト・納期をリサーチし、内製と比較
- **求人票作成**: 4類型モデルに基づき、求める人材像を明確化
- **スクリーニング**: 履歴書・職務経歴書から適性を判断
- **面接設計**: 構造化面接の質問シートを生成

### 2. 育成支援

- **業務のAIスキル化**: 認知的作業をCustom Skills形式で形式知化
- **マニュアル化**: 身体的作業を動画・写真付きマニュアルで形式知化
- **個別学習プラン**: オペレーター → スペシャリスト への育成ロードマップ作成
- **1on1質問設計**: 定性面の成長を促す質問シートを生成
- **成長の可視化**: 現在地と次のステップを明確化

### 3. 評価支援

- **外注QCD比較**: 同等業務の市場価格をリサーチし、客観的評価材料を提供
- **業務面の評価**: 生産性指標やAIスキル化への貢献度を整理
- **定性面の観点提示**: やる気・前進力・素直さなど、評価観点を提示
- **評価面談質問**: 建設的なフィードバックのための質問を生成

**重要**: Weaveは評価者にはなりません。データや観点を提示し、最終判断は人間が行います。

---

## 👥 人材4類型モデル

PersonnelDeveloperは、社員（社長を除く）を4つの類型で捉えます。

| 類型 | 役職イメージ | 業務の特徴 |
|------|------------|----------|
| **チームリーダー（軍人）** | 管理職・調整役 | 業務全体のバランスを整える、労働環境を整える |
| **イントラプレナー（天才）** | 新規事業担当 | 無駄な業務を省く、新しい業務を作る |
| **スペシャリスト（秀才）** | 専門職・中核人材 | AIスキル化されていない業務を回す、業務をAIスキル化する |
| **オペレーター（凡人）** | 実務担当者 | AIスキル化された業務を回す、違和感を適切に声にする |

### 採用の現実

- 中小企業で採用できるのは、基本的に**オペレーター**だけ
- チームリーダーやイントラプレナーは縁故で採る（市場から採用は困難）
- オペレーター採用前のAIスキル化は、陣容が整うまではWeaveの仕事

### 育成の目標

- **オペレーター → スペシャリスト** への育成を目標とする
- スペシャリストが突然変異して天才や軍人になることもあるが、期待はしない
- Weaveは業務面のアドバイザーに徹する（定性面には深く立ち入らない）

---

## 🔄 基本的な使い方

### 採用フェーズ

```markdown
# 使用例1: 採用前判断
「営業事務の業務を誰かに任せたいのですが、採用すべきでしょうか？」

→ PersonnelDeveloperが以下を実施：
  1. 業務内容の分析（認知的/身体的/対人的作業に分類）
  2. AIスキル化・マニュアル化の可能性を検討
  3. 外注QCD（品質・コスト・納期）のリサーチ
  4. 内製メリットと外注を比較
  5. 採用の要否を判断し、必要な人材類型を提案
```

```markdown
# 使用例2: 求人票作成
「オペレーター（経理実務担当）の求人票を作成してください」

→ PersonnelDeveloperが以下を作成：
  - 求める人材像（オペレーター類型）
  - 必須要件・歓迎要件
  - 業務内容とAIスキル化の状況
  - 成長機会（スペシャリストへの道筋）
  - 外注QCD比較に基づく待遇設定
```

### 育成フェーズ

```markdown
# 使用例3: 業務のAIスキル化
「見積書作成業務をAIスキル化したいです」

→ PersonnelDeveloperが以下を実施：
  1. 業務内容の分析（認知的作業か？）
  2. Custom Skills形式での形式知化
  3. SKILL.md形式で記述
  4. 新人が実行可能か検証し、改善提案
```

```markdown
# 使用例4: 個別学習プラン作成
「新人Aさんのスペシャリスト育成プランを作成してください」

→ PersonnelDeveloperが以下を作成：
  - 現状の把握（スキルレベル、得意・不得意）
  - 3ヶ月後、6ヶ月後、1年後の目標設定
  - 習得すべきスキルの棚卸しと優先順位
  - メンター・OJT担当者の指定提案
  - 1on1頻度の推奨
```

### 評価フェーズ

```markdown
# 使用例5: 外注QCD比較による評価材料作成
「経理担当Bさんの評価材料を整理してください」

→ PersonnelDeveloperが以下を実施：
  1. Bさんの業務内容の分析
  2. 同等業務の外注価格をリサーチ
     - クラウドソーシング相場
     - 専門業者の見積もり
     - 業界標準価格
  3. QCD比較（品質・コスト・納期）
  4. 内製メリットの定量化
  5. 客観的データシートを作成

※最終評価は人間が行います
```

---

## 🛡️ 倫理的境界線

PersonnelDeveloperには、明確な倫理的境界線があります。

### ❌ やらないこと

- **評価者にはならない**（十中八九揉めるため）
- **採用・育成・評価の「決定」はしない**（あくまで支援）
- **定性面（人間関係、モチベーション）には深く立ち入らない**

### ✅ やること

- **採用・育成・評価の「支援」を提供**（判断材料の整理、観点の提示）
- **業務面のアドバイザーに徹する**（客観的データの提供）
- **人間が判断しやすい形で情報を整理する**

---

## 📂 利用可能なテンプレート

PersonnelDeveloperは、以下の実務テンプレートを提供します：

1. **RecruitmentSheet.md** - 求人票テンプレート
2. **ScreeningCheckList.md** - スクリーニングチェックリスト
3. **InterviewQuestions.md** - 構造化面接質問集
4. **TrainingRoadmap.md** - 個別育成ロードマップ
5. **OneOnOneQuestions.md** - 1on1質問シート
6. **EvaluationFramework.md** - 評価フレームワーク

これらのテンプレートは、`Templates/` ディレクトリに格納されています。

---

## 🔗 他スキルとの連携

PersonnelDeveloperは、CorporateStrategist内の他のサブスキルと連携します。

```
CorporateStrategist（企業参謀）
├── BusinessAnalyzer（事業分析） → 事業・業務のToBe明確化
├── PersonnelDeveloper（人材開発） ← 本スキル
├── LegalAdviser（法務助言） → 労働法規の遵守確認
└── ForesightReader（洞察獲得） → 人間理解に基づく人材配置
```

---

## 💡 よくある質問（FAQ）

### Q1: PersonnelDeveloperは人事評価をしてくれますか？

**A**: いいえ。PersonnelDeveloperは評価者にはなりません。
外注QCD比較や生産性指標などの**客観的データを整理し、評価の材料を提供**しますが、最終判断は人間が行います。

### Q2: どの類型の人材を採用すべきですか？

**A**: 基本的には**オペレーター**の採用を前提としています。
中小企業で即戦力のスペシャリストや管理職を市場から採用するのは困難です。オペレーターを採用し、スペシャリストに育成することを推奨します。

### Q3: AIスキル化できない業務はどうすればいいですか？

**A**: 業務の種類によって対応が異なります：
- **認知的作業** → Custom Skills形式でAIスキル化
- **身体的作業** → 動画・写真付きマニュアル化
- **対人的作業** → マニュアル化 + AIロールプレイ環境

ブルーカラー職種の場合、「AIスキル」を「マニュアル」に読み替えます。

### Q4: 外注QCD比較はどうやって行いますか？

**A**: 以下の方法でリサーチします：
1. **クラウドソーシング調査**（ランサーズ、クラウドワークス、ココナラ）
2. **専門業者の見積もり**（BPO企業、業界特化型業者）
3. **業界標準価格の調査**（業界団体の公開資料、統計データ）

詳細は `References/外注QCD比較手法.md` を参照してください。

### Q5: 評価は何段階がいいですか？

**A**: **4段階評価**を推奨します。
3段階・5段階だと中央に評価が固まる傾向があります。4段階評価（大きく下回る / やや下回る / 期待通り / 上回る）にすることで、評価を明確化しやすくなります。

---

## 📖 さらに詳しく知りたい方へ

- **CLAUDE.md** - システム仕様書（詳細理論、業務フレームワーク）
- **References/** - 理論参考資料（人材4類型詳細、外注QCD比較手法、AIスキル化判定基準）
- **Templates/** - 実務テンプレート集（即座に使える各種シート）

---

*PersonnelDeveloper - 採用不可能性を前提とした、中小企業特化型人事システム*

*Last Updated: 2025-11-02*
*Maintained by: Weave @ Homunculus-Weave*
