# 評価フレームワーク

**対象者名**: [氏名]
**評価期間**: YYYY-MM-DD 〜 YYYY-MM-DD
**評価者**: [担当者名]
**評価実施日**: YYYY-MM-DD

---

## 🎯 評価の目的と方針

### 基本方針

- **Weaveは評価者にはならない**（客観的データを提示し、最終判断は人間が行う）
- **外注QCD比較**により、市場価値との比較を行う
- **業務面と定性面**の両面から評価材料を整理する
- **4段階評価**を推奨（中央に固まることを防ぐ）

### 評価の構成

1. **外注QCD比較**（市場価格との比較）
2. **業務面の評価材料整理**（客観的データ）
3. **定性面の評価観点提示**（平時/有事別）
4. **評価面談の実施**（建設的なフィードバック）

---

## 📊 外注QCD比較（市場価格との比較）

### 業務内容の整理

**主な業務**:
1. [業務1]
   - 工数：[時間/月]
   - 難易度：[高 / 中 / 低]

2. [業務2]
   - 工数：[時間/月]
   - 難易度：[高 / 中 / 低]

3. [業務3]
   - 工数：[時間/月]
   - 難易度：[高 / 中 / 低]

### Quality（品質）

**外注の品質水準**:
- リサーチ結果：[具体的な品質水準]
- レビュー評価：[評価点数や口コミ]
- 実績：[具体的な実績]

**内製の品質水準**:
- エラー率：[％]
- やり直し率：[％]
- 顧客満足度：[具体的な評価]

**品質の比較**:
- [ ] 内製が外注を上回る
- [ ] 内製と外注が同等
- [ ] 外注が内製を上回る

---

### Cost（コスト）

**外注コスト**:
- 見積もり価格：[金額/月]
- 管理コスト：[金額/月]
- 隠れコスト：[金額/月]
- **合計**：[金額/月]

**内製コスト**:
- 人件費（実績）：[金額/月]
- 教育費：[金額/月]
- 管理コスト：[金額/月]
- **合計**：[金額/月]

**コスト比較**:
- 内製コスト ÷ 外注コスト = [比率]
- [ ] 内製が外注より20%以上安い
- [ ] 内製と外注がほぼ同等（±20%以内）
- [ ] 外注が内製より20%以上安い

---

### Delivery（納期）

**外注の納期**:
- 通常納期：[X日]
- 急ぎ対応：[可能 / 不可能]
- 柔軟性：[高 / 中 / 低]

**内製の納期**:
- 通常納期：[X日]
- 急ぎ対応：[即座対応可能]
- 柔軟性：[高]

**納期の比較**:
- [ ] 内製が外注より迅速
- [ ] 内製と外注が同等
- [ ] 外注が内製より迅速

---

### 内製メリットの定量化

| 項目 | 内製のメリット | 定量化 |
|------|--------------|-------|
| ノウハウ蓄積 | 組織資産として蓄積 | [教育コスト削減額: X円] |
| 柔軟性 | 即座対応・細かい調整可能 | [機会損失の回避額: X円] |
| 秘匿性 | 機密情報の漏洩リスク低減 | [リスク回避の価値: X円] |
| 一体感 | チームの結束力向上 | [離職率低下の効果: X円] |

**内製メリット合計**: [金額]

---

### QCD総合評価

**市場価格比較の結論**:
[外注QCD比較の結果をまとめて記載]

**コストパフォーマンス**:
- [ ] 内製が外注を大きく上回る
- [ ] 内製が外注をやや上回る
- [ ] 内製と外注が同等
- [ ] 外注が内製を上回る

---

## 💼 業務面の評価材料整理

### 生産性指標の算出

**処理件数（定量的成果）**:
- 処理件数：[X件/月]
- 前期比：[+X% / -X%]
- 目標達成率：[％]

**処理時間（効率性）**:
- 平均処理時間：[X時間/件]
- 前期比：[+X% / -X%]
- 目標達成率：[％]

**エラー率（品質）**:
- エラー率：[％]
- 前期比：[+X% / -X%]
- 目標達成率：[％]

---

### AIスキル化/マニュアル化への貢献度

**作成したCustom Skillsの数**: [X個]

| No. | Custom Skills名 | 作成日 | 活用状況 |
|-----|----------------|-------|---------|
| 1 | [スキル名1] | [YYYY-MM] | [高 / 中 / 低] |
| 2 | [スキル名2] | [YYYY-MM] | [高 / 中 / 低] |
| 3 | [スキル名3] | [YYYY-MM] | [高 / 中 / 低] |

**マニュアル化した業務の数**: [X個]

| No. | マニュアル名 | 作成日 | 活用状況 |
|-----|------------|-------|---------|
| 1 | [マニュアル名1] | [YYYY-MM] | [高 / 中 / 低] |
| 2 | [マニュアル名2] | [YYYY-MM] | [高 / 中 / 低] |
| 3 | [マニュアル名3] | [YYYY-MM] | [高 / 中 / 低] |

**組織への知識移転の度合い**:
- 後輩育成の実績：[X人]
- 形式知化の成果：[具体的な成果]
- 組織への貢献度：[高 / 中 / 低]

---

### 業務面の総合評価（客観的データ）

**提示するデータ**:
「以下のような客観的データがあります」

1. 生産性指標：[具体的な数値]
2. AIスキル化への貢献：[具体的な成果]
3. 外注QCD比較結果：[市場価値との比較]

**重要**: これらはあくまで客観的データであり、最終的な評価判断は人間が行う。

---

## 💡 定性面の評価観点提示

### 対応者の類型確認

- [ ] **平時対応者**（オペレーター、スペシャリスト）
- [ ] **有事対応者**（チームリーダー、イントラプレナー）

---

### 平時対応者の評価観点

#### 1. やる気

**観点**:
- 仕事への熱意が感じられるか
- 主体的に取り組んでいるか
- 成長意欲があるか

**具体的なエピソード**:
[評価期間中のエピソードを記録]

**4段階評価**:
- [ ] Level 4: 期待を上回る（非常に高い熱意と主体性）
- [ ] Level 3: 期待通り（適切な熱意と主体性）
- [ ] Level 2: 期待をやや下回る（やや受動的）
- [ ] Level 1: 期待を大きく下回る（熱意が感じられない）

---

#### 2. 前進力

**観点**:
- 困難に立ち向かっているか
- 改善提案をしているか
- 新しいことに挑戦しているか

**具体的なエピソード**:
[評価期間中のエピソードを記録]

**4段階評価**:
- [ ] Level 4: 期待を上回る（積極的に困難に立ち向かう）
- [ ] Level 3: 期待通り（適切に困難に対応）
- [ ] Level 2: 期待をやや下回る（やや消極的）
- [ ] Level 1: 期待を大きく下回る（困難を避ける傾向）

---

#### 3. 素直さ

**観点**:
- フィードバックを受け入れているか
- 自分の非を認められるか
- 学ぶ姿勢があるか

**具体的なエピソード**:
[評価期間中のエピソードを記録]

**4段階評価**:
- [ ] Level 4: 期待を上回る（非常に素直で学ぶ姿勢が強い）
- [ ] Level 3: 期待通り（適切にフィードバックを受け入れる）
- [ ] Level 2: 期待をやや下回る（やや頑固）
- [ ] Level 1: 期待を大きく下回る（フィードバックを拒否）

---

### 有事対応者の評価観点

#### 1. 勝ちにこだわる

**観点**:
- 結果に執着しているか
- 諦めずに最後までやり抜くか
- 目標達成への強い意志があるか

**具体的なエピソード**:
[評価期間中のエピソードを記録]

**4段階評価**:
- [ ] Level 4: 期待を上回る（強い執着心で結果を出す）
- [ ] Level 3: 期待通り（適切に結果にこだわる）
- [ ] Level 2: 期待をやや下回る（やや結果意識が弱い）
- [ ] Level 1: 期待を大きく下回る（結果にこだわらない）

---

#### 2. リソースを使いこなす

**観点**:
- 人・モノ・金を適切に配分しているか
- 外部リソースを効果的に活用しているか
- 制約の中で最大の成果を出しているか

**具体的なエピソード**:
[評価期間中のエピソードを記録]

**4段階評価**:
- [ ] Level 4: 期待を上回る（リソースを最大限活用）
- [ ] Level 3: 期待通り（適切にリソースを活用）
- [ ] Level 2: 期待をやや下回る（やや活用が不足）
- [ ] Level 1: 期待を大きく下回る（リソースを活用できない）

---

#### 3. 未来を見通す

**観点**:
- 先を読んで行動しているか
- リスクを予測して対策しているか
- 長期的視点を持っているか

**具体的なエピソード**:
[評価期間中のエピソードを記録]

**4段階評価**:
- [ ] Level 4: 期待を上回る（先を読んで的確に行動）
- [ ] Level 3: 期待通り（適切にリスクを予測）
- [ ] Level 2: 期待をやや下回る（やや視野が狭い）
- [ ] Level 1: 期待を大きく下回る（場当たり的）

---

## 📋 評価面談の準備

### 評価面談の質問設計

#### 1. 成長を認める質問

「この半年で最も成長したと感じることは何ですか？」

**目的**: ポジティブなフィードバックから始める

**回答メモ**:
[本人の回答を記録]

---

「どの業務に手応えを感じましたか？」

**目的**: 具体的な成功体験を共有

**回答メモ**:
[本人の回答を記録]

---

#### 2. 課題を自覚させる質問

「次に挑戦したいことは何ですか？」

**目的**: 自律的な成長を促す

**回答メモ**:
[本人の回答を記録]

---

「改善したいと思っていることはありますか？」

**目的**: 自己認識の確認

**回答メモ**:
[本人の回答を記録]

---

#### 3. 組織への貢献を確認する質問

「チームにどのように貢献できたと思いますか？」

**目的**: 組織への意識を確認

**回答メモ**:
[本人の回答を記録]

---

「他のメンバーをどのようにサポートしましたか？」

**目的**: 協調性の確認

**回答メモ**:
[本人の回答を記録]

---

#### 4. 次の成長への橋渡し

「来期の目標は何ですか？」

**目的**: 次の期間への意識付け

**回答メモ**:
[本人の回答を記録]

---

「どんなサポートがあれば達成できそうですか？」

**目的**: サポート体制の確認

**回答メモ**:
[本人の回答を記録]

---

## 🎯 総合評価（最終判断は人間）

### 業務面の評価

**外注QCD比較の結果**: [具体的な結果]
**生産性指標**: [具体的な数値]
**AIスキル化への貢献**: [具体的な成果]

**業務面の総合評価**:
- [ ] Level 4: 期待を上回る
- [ ] Level 3: 期待通り
- [ ] Level 2: 期待をやや下回る
- [ ] Level 1: 期待を大きく下回る

---

### 定性面の評価

| 項目 | 評価 | 詳細 |
|------|------|------|
| やる気 / 勝ちにこだわる | [Level 1-4] | [具体的なエピソード] |
| 前進力 / リソース活用 | [Level 1-4] | [具体的なエピソード] |
| 素直さ / 未来を見通す | [Level 1-4] | [具体的なエピソード] |

**定性面の総合評価**:
- [ ] Level 4: 期待を上回る
- [ ] Level 3: 期待通り
- [ ] Level 2: 期待をやや下回る
- [ ] Level 1: 期待を大きく下回る

---

### 総合所見

**この期間の成果**:
[具体的な成果を記載]

**成長した点**:
[具体的な成長を記載]

**改善が必要な点**:
[具体的な改善点を記載]

**次期の目標**:
[次期に向けた目標を記載]

---

## 📝 評価面談実施記録

**実施日**: [YYYY-MM-DD]
**実施時間**: [X分]
**実施場所**: [場所]

### 面談の内容

**本人の反応**:
[評価に対する本人の反応を記録]

**合意した目標**:
1. [目標1]
2. [目標2]
3. [目標3]

**必要なサポート**:
1. [サポート1]
2. [サポート2]
3. [サポート3]

---

## 📝 備考

[その他特記事項]

---

*PersonnelDeveloper - EvaluationFramework Template*
*Last Updated: 2025-11-02*
