# CorporateStrategist クイックスタートガイド

**5分で始める企業参謀システム**

最終更新: 2025-11-03
バージョン: 1.0

---

## 📖 このガイドについて

CorporateStrategistを初めて使う方向けの実践ガイドです。
最短経路で価値を実感していただけるよう、段階的な活用方法を示します。

**読了時間**: 約5分
**実践時間**: 約30分で最初の成果

---

## 📊 期待できる成果（DISCLAIMER.mdより）

本システムの成果は、以下の経営指標に直接現れます：
- **採用コスト削減**: AI活用と外注最適化による人件費抑制
- **業務効率向上**: AIスキル化による生産性向上
- **離職率低下**: 適材適所と育成システムの確立
- **法務リスク低減**: 契約書の標準化とチェック体制

これらは経営者が自社の業績を通じて判断すべき領域です。

---

## 🎯 最初の一歩：30分で成果を出す

### ケース1：採用を検討している場合（推奨）

```
あなた: 「営業事務を採用しようと思っているが、PersonnelDeveloperで判断してほしい」

Weave: [PersonnelDeveloperを起動し、以下を実施]
1. 業務内容の分析（認知的/身体的/対人的に分類）
2. AI活用可能性の検討
3. 外注QCD（品質・コスト・納期）のリサーチ
4. 内製メリットと外注の比較
5. 採用の要否判断と推奨アクション
```

**期待成果**: 年間100-300万円の人件費削減の可能性を30分で判断

---

### ケース2：既存業務を効率化したい場合

```
あなた: 「見積書作成業務が属人化している。BusinessAnalyzerで構造化してほしい」

Weave: [BusinessAnalyzerを起動し、以下を実施]
1. 現状業務フローのヒアリング
2. Multiversal Structure Parserで構造分析
3. AIスキル化可能な部分の特定
4. 業務フロー最適化案の提示
```

**期待成果**: 業務時間を50%削減できる構造化案を即座に入手

---

### ケース3：契約書をチェックしたい場合

```
あなた: 「業務委託契約書を作りたい。LegalAdviserで作成してほしい」

Weave: [LegalAdviserを起動し、44種類のテンプレートから最適なものを選択・カスタマイズ]
```

**期待成果**: 弁護士費用10-30万円相当の契約書を10分で作成

---

## 🔄 サブスキル連携パターン（実践例）

### パターンA：採用から育成まで一気通貫

**シナリオ**: 新規事業のためにエンジニアを採用したい

```
第1段階：BusinessAnalyzer
「新規事業の構造を分析」
↓
第2段階：PersonnelDeveloper
「必要な人材要件を定義し、採用可否を判断」
↓
第3段階：LegalAdviser
「雇用契約書・業務委託契約書を作成」
↓
第4段階：PersonnelDeveloper
「オンボーディングとスキルアップ計画を作成」
```

**実行例**：
```
あなた: 「ECサイト事業を立ち上げたい。必要な人材も含めて総合的に相談したい」

Weave: 「BusinessAnalyzer + PersonnelDeveloper + LegalAdviserの3つで対応します。
まずBusinessAnalyzerでEC事業の構造を分析し、次にPersonnelDeveloperで
人材戦略を立案、最後にLegalAdviserで必要な契約書を準備します。
よろしいですか？」
```

---

### パターンB：組織再編プロジェクト

**シナリオ**: 業績不振部門の立て直し

```
第1段階：BusinessAnalyzer
「部門の事業構造と問題点を分析」
↓
第2段階：PersonnelDeveloper
「人材の再配置案を作成」
↓
第3段階：ForesightReader（希望者のみ）
「キーパーソンの適性を占術的観点から分析」
↓
第4段階：PersonnelDeveloper
「新体制での育成計画を策定」
```

---

### パターンC：外注最適化プロジェクト

**シナリオ**: コスト削減のため業務の外注化を検討

```
第1段階：BusinessAnalyzer
「全業務の棚卸しと構造化」
↓
第2段階：PersonnelDeveloper
「各業務の外注QCD分析」
↓
第3段階：LegalAdviser
「外注先との業務委託契約書作成」
```

---

## 📈 習熟度別活用ロードマップ

### Level 1：単一サブスキル活用期（1週間）
- **目標**: 各サブスキルを個別に使いこなす
- **推奨**: PersonnelDeveloperから始める（即効性が高い）
- **成功指標**: 1つの具体的な経営判断に活用

### Level 2：連携活用期（1ヶ月）
- **目標**: 2つのサブスキルを連携させる
- **推奨**: PersonnelDeveloper + LegalAdviserの組み合わせ
- **成功指標**: 採用プロセス全体を支援

### Level 3：統合活用期（3ヶ月）
- **目標**: 状況に応じて最適なサブスキルの組み合わせを選択
- **推奨**: 新規事業立ち上げなど複合的なプロジェクトに活用
- **成功指標**: 事業戦略から実行まで一貫した支援

### Level 4：発展的活用期（6ヶ月〜）
- **目標**: 自社特有の活用パターンを確立
- **推奨**: ForesightReaderも含めた全機能の活用
- **成功指標**: 経営の意思決定速度が2倍以上に向上

---

## 💡 効果的な活用のコツ

### 1. 具体的な問題から始める
❌ 「経営全般について相談したい」
⭕ 「営業事務の採用を検討している」

### 2. サブスキル名を明示する
❌ 「人事について相談したい」
⭕ 「PersonnelDeveloperで採用判断をしてほしい」

### 3. 段階的に複雑化する
1. 単一サブスキルで成功体験
2. 2つのサブスキル連携
3. プロジェクト全体での活用

### 4. 定期的な振り返り
- 月1回、活用状況と成果を振り返る
- 新たな活用パターンを発見する
- 他部門への展開を検討する

---

## ❓ よくある質問

### Q1: どのサブスキルから始めるべき？
**A**: PersonnelDeveloperがおすすめ。採用・外注の判断は即座に費用対効果が見えやすい。

### Q2: 占術（ForesightReader）は使うべき？
**A**: 任意です。人材配置や意思決定で悩んだ時の補助ツールとして活用する経営者もいます。

### Q3: 全部のサブスキルを一度に使える？
**A**: 可能ですが、最初は1-2個から始めることを推奨。慣れたら組み合わせを増やしていく。

### Q4: 効果測定はどうすれば？
**A**: 売上・利益・離職率など、既存の経営指標で判断してください。本システムは意思決定を支援するツールです。

---

## 🎬 今すぐ始める

**最初のアクション**：
1. 今抱えている具体的な経営課題を1つ選ぶ
2. 上記のケース1-3から最も近いものを参考にする
3. 「[サブスキル名]で[具体的な課題]を解決したい」と依頼する

**30分後には、具体的な解決策が手に入ります。**

---

## 📚 さらに詳しく

- **基本仕様**: [SKILL.md](./SKILL.md)
- **詳細理論**: [CLAUDE.md](./CLAUDE.md)
- **免責事項**: [DISCLAIMER.md](./DISCLAIMER.md)
- **各サブスキル詳細**: 各サブディレクトリのSUBSKILL.mdを参照

---

*Start small, think big, move fast.*

*CorporateStrategist - 中小企業経営者の、最も頼れる参謀として*

---

*Last Updated: 2025-11-03*
*Maintained by: Weave @ Homunculus-Weave*
*Version: 1.0*
