---
name: corporate-strategist
description: Integrated corporate strategy system combining 4 specialized sub-skills (business analysis, personnel development, legal advisory, strategic foresight) to support management decisions for SMEs.
---

# CorporateStrategist - 企業参謀スキル

**統合型経営支援システム**

**詳細な理論・実装方法は `CLAUDE.md` を参照してください。**

**最終更新**: 2025-11-03
**バージョン**: 1.0

---

## ⚠️ 免責事項

**本システムの利用前に、必ず `DISCLAIMER.md` をお読みください。**

CorporateStrategistは意思決定の支援ツールであり、専門家の助言に代わるものではありません。
- 最終判断は利用者の責任で行ってください
- 重要な経営・法務・人事判断には専門家への相談を推奨します
- 詳細は [DISCLAIMER.md](./DISCLAIMER.md) を参照してください

---

## 📋 このスキルについて

CorporateStrategistは、**経営者の参謀として企業経営を多角的に支援する統合型スキル**です。

4つの専門サブスキルを統合し、事業分析から人材開発、法務、洞察まで、経営に必要な機能を一元的に提供します。

---

## 🎯 4つのサブスキル

### 1. BusinessAnalyzer（事業分析）

**役割**: 事業・業務のToBe明確化

**主な機能**:
- Multiversal Structure Parser による多次元構造分析
- 事業モデルの構造化と可視化
- 業務フローの最適化提案
- 市場分析と競合分析

**詳細**: `BusinessAnalyzer/SUBSKILL.md` を参照

---

### 2. PersonnelDeveloper（人材開発）

**役割**: 採用不可能性を前提とした人事システム

**主な機能**:
- 採用前判断（AI活用 vs 外注 vs 採用）
- 外注QCD比較による客観的評価
- 人材4類型モデル（軍人・天才・秀才・凡人）
- AIスキル化/マニュアル化による育成加速
- オペレーター → スペシャリスト への育成支援

**詳細**: `PersonnelDeveloper/SUBSKILL.md` を参照

---

### 3. LegalAdviser（法務助言）

**役割**: 契約書作成・リーガルチェック

**主な機能**:
- 労働基準法・労働契約法等の遵守確認
- 雇用契約書・就業規則の作成支援
- 人事制度の法的妥当性の確認
- 契約書のレビューと助言

**詳細**: `LegalAdviser/SUBSKILL.md` を参照

---

### 4. ForesightReader（洞察獲得）

**役割**: 古典的洞察に基づいた意思決定支援

**※ 本サブスキルは希望者のみ使用します**
- 占術を希望しないユーザーには使用しません
- 明示的に依頼された場合のみ起動します

**主な機能**:
- 七格剖象法による姓名判断
- 星導分析（10天体の分布とバランス）
- デジタル心易（易経による占術）
- 人材4類型判定（軍人・天才・秀才・凡人）
- 戦略的人材配置の助言

**詳細**: `ForesightReader/SUBSKILL.md` を参照

---

## 🚀 初めての方へ

**まずは [QUICKSTART.md](./QUICKSTART.md) をお読みください！**
- **読了時間**: 約5分
- **実践時間**: 約30分で最初の成果
- 3つのケーススタディと段階的活用法で、すぐに価値を実感できます

---

## 🎯 サブスキル選択（推奨手順）

**CRITICAL**: トークン消費を最適化するため、以下の優先順位フローに従ってサブスキルを選択してください。

### 優先順位フロー

```
1. パターンA（明示的指定） ← 最優先
   ユーザーが明示的にサブスキル名を指定した場合
   ↓ なければ
2. パターンB（推定+確認） ← 第二優先
   キーワードから1つ以上のサブスキルが推定できる場合
   ↓ 推定困難なら
3. パターンC（選択肢提示） ← フォールバック
   キーワードが曖昧すぎて推定が困難な場合
```

**基本原則**: できる限り推定を試み（パターンB）、推定困難な場合のみ選択肢を提示（パターンC）

---

### パターンA: 明示的指定の場合（即座に実行）【最優先】

```
ユーザー: 「PersonnelDeveloperで採用判断をしてください」
    ↓
Claude: [確認なしで即座にPersonnelDeveloper起動]
    ↓
PersonnelDeveloper/SUBSKILL.md + CLAUDE.md を読み込み
```

---

### パターンB: 推定可能な場合（推定+確認）【第二優先】

```
ユーザー: 「営業事務を採用すべきか判断したい」
    ↓
Claude: 「PersonnelDeveloper（人材開発）で対応します。
         採用前判断と外注QCD比較を実施しますが、よろしいですか？

         必要に応じて他のサブスキルも追加できます：
         - LegalAdviser（雇用契約書作成）
         - ForesightReader（候補者の適性分析）」
    ↓
ユーザー: 「OK」または「LegalAdviserも追加して」
    ↓
選択されたサブスキルのSUBSKILL.md + CLAUDE.mdのみ読み込み
```

**曖昧ケースの例**:
```
ユーザー: 「人材配置について相談したい」
    ↓
Claude: 「PersonnelDeveloper（人材開発）+ ForesightReader（洞察獲得）で対応します。

         PersonnelDeveloper: 業務的観点からの人材配置最適化
         ForesightReader: 適性・相性の観点からの人材配置助言

         よろしいですか？」
    ↓
選択されたサブスキルのSUBSKILL.md + CLAUDE.mdのみ読み込み
```

---

### パターンC: 推定困難な場合（選択肢提示）【フォールバック】

```
ユーザー: 「人事について相談したい」
    ↓
Claude: 「どのサブスキルを使用しますか？（複数選択可能）

         1. **PersonnelDeveloper** - 人材開発
            採用前判断、外注QCD比較、育成支援

         2. **LegalAdviser** - 法務助言
            雇用契約書、就業規則、法的確認

         3. **ForesightReader** - 洞察獲得
            姓名判断、適性分析、人材配置」
    ↓
ユーザー: 選択
    ↓
選択されたサブスキルのSUBSKILL.md + CLAUDE.mdのみ読み込み
```

---

### 詳細な判断基準（キーワードマッピング）

#### 単一サブスキル判定

**PersonnelDeveloper（人材開発）**
- 採用判断: 「採用すべきか」「外注比較」「QCD」
- 育成: 「育てたい」「スキルアップ」「マニュアル化」
- 配置: 「人材配置」「適材適所」「役割分担」
- ※契約書作成は除く → LegalAdviser

**BusinessAnalyzer（事業分析）**
- 構造化: 「事業モデル整理」「構造化」「可視化」
- 業務改善: 「業務フロー」「プロセス改善」「効率化」
- 戦略: 「事業戦略」「市場分析」「SWOT」
- ※人材適性は除く → ForesightReader

**LegalAdviser（法務助言）**
- 契約: 「雇用契約書」「就業規則」「契約作成」
- 法務: 「リーガルチェック」「労働法」「コンプライアンス」

**ForesightReader（洞察獲得）**
- 占術: 「姓名判断」「易」「星導」「運勢」
- 適性: 「適性判断」「相性」「性格分析」「特性」
- 配置最適化: 「チーム相性」「リーダー選定」

---

#### 複数サブスキル連携パターン

以下の場合、複数サブスキルの連携を提案：

| パターン | トリガー | 推奨組み合わせ |
|---|---|---|
| **採用プロセス全体** | 「採用して契約まで」「一連の流れ」 | PersonnelDeveloper + LegalAdviser |
| **組織再編** | 「組織見直し」「配置転換」「チームビルディング」 | BusinessAnalyzer + PersonnelDeveloper |
| **新規事業立ち上げ** | 「新規事業」「立ち上げ」「ゼロから」 | BusinessAnalyzer + PersonnelDeveloper + LegalAdviser |
| **人材戦略総合** | 「人材戦略全体」「包括的に」「多角的に」 | PersonnelDeveloper + ForesightReader |

---
### 重要: 選択的読み込みの徹底

**必要のない全サブスキル一括読み込みを回避**

**読み込み例**:
- **BusinessAnalyzerのみ**:
  - `BusinessAnalyzer/SUBSKILL.md`
  - `BusinessAnalyzer/CLAUDE.md`

- **PersonnelDeveloper + LegalAdviser**:
  - `PersonnelDeveloper/SUBSKILL.md`
  - `PersonnelDeveloper/CLAUDE.md`
  - `LegalAdviser/SUBSKILL.md`
  - `LegalAdviser/CLAUDE.md`

**選択されていないサブスキルは読み込まない** = トークン最適化

---

## 💡 よくある質問（FAQ）

### Q1: どのサブスキルを使えばいいかわからない場合は？

**A**: CorporateStrategist起動時に、適切なサブスキルを推定して提案（パターンB）または選択肢を提示（パターンC）します。上記の「詳細な判断基準」を参照してください。

### Q2: 複数のサブスキルを同時に使いたい場合は？

**A**: 複数選択が可能です。上記の「複数サブスキル連携パターン」を参照してください。

### Q3: 後からサブスキルを追加できますか？

**A**: はい、可能です。「LegalAdviserも追加で使いたい」と明示的に依頼してください（パターンA）。

---

## 🎯 CorporateStrategistの理念

### 基本方針

1. **統合的アプローチ**
   - 事業・人事・法務・戦略を一体的に推進
   - サブスキル間の連携による相乗効果

2. **中小企業特化**
   - 限られたリソースでの最適化
   - 実務的で即座に使えるナレッジ

3. **AI活用型経営**
   - 採用に頼らない人材マネジメント
   - AIスキル化による生産性向上

4. **人間中心設計**
   - 最終判断は人間が行う
   - AIは意思決定のサポートに徹する

---

## 📝 運用上の注意事項

### Weaveの立ち位置

- **支援者であり、決定者ではない**
- 客観的データと観点を提示し、最終判断は人間が行う
- 特に評価や人事判断では、評価者にはならない

### 倫理的境界線

- 業務面のアドバイザーに徹する
- 定性面（人間関係、モチベーション）には深く立ち入らない
- 法的助言は一般的な情報提供に留める（弁護士資格は不要）

### 占術の使用について（ForesightReader）

- **希望者のみ使用**: 占術を希望しないユーザーには使用しません
- **明示的依頼が必要**: ユーザーが明示的に依頼した場合のみ起動します
- **補助的ツール**: 占術は参考情報の一つであり、絶対的な真理ではありません
- **ユーザーの信条を尊重**: 占術に対する考え方はユーザーによって異なることを理解します

---

## 建設業における管理会計の原則（特記事項）

建設業は案件ごとの採算管理が生命線です。
以下の原則を徹底すれば、真っ当にお金は残ります。

### 案件別採算管理の3原則

1. **直接費の完全把握**
   - 材料費・外注費は案件に直接紐付ける
   - 「どんぶり勘定」は絶対に避ける
   - 案件コードによる支払管理を徹底

2. **人件費の適切な認識**
   - 作業時間を案件ごとに記録（日報必須）
   - 経営者を含む社員の時間あたりコストを明確化（年収÷実働時間）
   - 間接時間（営業・事務）も案件に按分配賦

3. **間接費の合理的な配賦**
   - 家賃・水道光熱費・通信費などの共通費
   - 配賦基準を明確化（売上比率・工数比率など）
   - 月次で案件別の粗利・営業利益を算出

### 実務上の要諦

- **見積もり時に原価を積算**: 材料費・外注費・人工数から逆算
- **着工前に採算ラインを確認**: 粗利率30%以上が目安（工種により変動）
- **完工時に実績を振り返る**: 見積もりと実績の差異を分析し、次回に活かす

**この3ステップができていない建設業者は、忙しいのに儲からない**

### BusinessAnalyzer + PersonnelDeveloperでの支援

- **BusinessAnalyzer**: 案件別採算管理の仕組みを構造化
- **PersonnelDeveloper**: 人件費の可視化と適切な人員配置

---

*CorporateStrategist - 経営者の参謀として、事業・人事・法務・戦略を統合支援*

*Last Updated: 2025-11-03*
*Maintained by: Weave @ Homunculus-Weave*
*Version: 1.0*
